/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.composites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.TaskModel;
import org.jboss.ide.eclipse.as.wtp.core.util.VMInstallUtil;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.composites.IJRECompositeListener;

public abstract class AbstractJREComposite
extends Composite {
    protected static final String JAVA_PREF_PAGE_ID = "org.eclipse.jdt.ui.preferences.JavaBasePreferencePage";
    protected static final String JRE_PREF_PAGE_PATH = "org.eclipse.jdt.ui.preferences.JavaBasePreferencePage/org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    protected static final String EXEC_ENV_PREF_PAGE_PATH = "org.eclipse.jdt.ui.preferences.JavaBasePreferencePage/org.eclipse.jdt.debug.ui.preferences.VMPreferencePage/org.eclipse.jdt.debug.ui.jreProfiles";
    private TaskModel taskModel;
    private Group installedJREGroup;
    private Combo alternateJRECombo;
    private Combo execEnvironmentCombo;
    private Button execenvRadio;
    private Button vmRadio;
    private Button environmentsButton;
    private Button installedJREsButton;
    private List<IVMInstall> compatibleJREs;
    private List<IVMInstall> allJREs;
    private String[] jreNames;
    protected IVMInstall selectedVM;
    protected IExecutionEnvironment selectedExecutionEnvironment;
    private IExecutionEnvironment[] validExecutionEnvironments;
    private String[] validExecutionEnvironmentNames;
    private IJRECompositeListener listener;
    private ModifyListener comboModifyListener;

    public AbstractJREComposite(Composite parent, int style, TaskModel tm) {
        super(parent, style);
        this.taskModel = tm;
        this.createJREComposite(this);
    }

    protected TaskModel getTaskModel() {
        return this.taskModel;
    }

    public void setListener(IJRECompositeListener listener) {
        this.listener = listener;
    }

    protected void createJREComposite(Composite main) {
        this.setLayout((Layout)new FillLayout());
        this.createWidgets();
        this.loadModel();
        this.fillWidgets();
        this.addInternalListeners();
        this.vmChanged();
    }

    protected void addInternalListeners() {
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJREComposite.this.radioClicked();
            }
        };
        this.execenvRadio.addSelectionListener((SelectionListener)sl);
        this.vmRadio.addSelectionListener((SelectionListener)sl);
        this.comboModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractJREComposite.this.vmChanged();
            }
        };
        this.execEnvironmentCombo.addModifyListener(this.comboModifyListener);
        this.alternateJRECombo.addModifyListener(this.comboModifyListener);
        this.environmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJREComposite.this.showPreferencePage(AbstractJREComposite.EXEC_ENV_PREF_PAGE_PATH);
            }
        });
        this.installedJREsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJREComposite.this.jreButtonPressed();
            }
        });
    }

    private void radioClicked() {
        this.execEnvironmentCombo.setEnabled(this.execenvRadio.getSelection());
        this.alternateJRECombo.setEnabled(!this.execenvRadio.getSelection());
        this.vmChanged();
    }

    protected void refreshWidgets() {
        int ind;
        int selIndex = this.execEnvironmentCombo == null ? -1 : this.execEnvironmentCombo.getSelectionIndex();
        this.execEnvironmentCombo.setItems(this.validExecutionEnvironmentNames);
        if (selIndex != -1) {
            this.execEnvironmentCombo.select(selIndex);
        } else {
            this.execEnvironmentCombo.deselectAll();
        }
        this.alternateJRECombo.setItems(this.jreNames);
        int n = ind = this.selectedVM == null ? -1 : this.getDisplayableJREList().indexOf(this.selectedVM);
        if (ind != -1) {
            this.alternateJRECombo.select(ind);
        } else {
            this.alternateJRECombo.deselectAll();
        }
    }

    protected void fillWidgets() {
        this.execEnvironmentCombo.setItems(this.validExecutionEnvironmentNames);
        IExecutionEnvironment toSelect = this.selectedExecutionEnvironment != null ? this.selectedExecutionEnvironment : this.getStoredExecutionEnvironment();
        int selIndex = -1;
        if (toSelect != null) {
            String id = toSelect.getId();
            selIndex = Arrays.asList(this.validExecutionEnvironmentNames).indexOf(id);
        }
        this.execEnvironmentCombo.select(selIndex == -1 ? 0 : selIndex);
        this.alternateJRECombo.setItems(this.jreNames);
        selIndex = -1;
        IVMInstall hardSelected = this.selectedVM != null ? this.selectedVM : this.getStoredJRE();
        this.execenvRadio.setSelection(hardSelected == null);
        this.vmRadio.setSelection(hardSelected != null);
        if (hardSelected != null) {
            String name = hardSelected.getName();
            selIndex = Arrays.asList(this.jreNames).indexOf(name);
        }
        this.alternateJRECombo.select(selIndex == -1 ? 0 : selIndex);
        this.execEnvironmentCombo.setEnabled(this.execenvRadio.getSelection());
        this.alternateJRECombo.setEnabled(this.vmRadio.getSelection());
    }

    protected void loadModel() {
        IExecutionEnvironment min = this.getMinimumExecutionEnvironment();
        this.validExecutionEnvironments = this.findAllValidEnvironments(min);
        this.validExecutionEnvironmentNames = new String[this.validExecutionEnvironments.length];
        int i = 0;
        while (i < this.validExecutionEnvironments.length) {
            this.validExecutionEnvironmentNames[i] = this.validExecutionEnvironments[i].getId();
            ++i;
        }
        this.compatibleJREs = new ArrayList<IVMInstall>();
        IVMInstall[] compat = min.getCompatibleVMs();
        this.compatibleJREs.addAll(Arrays.asList(compat));
        this.allJREs = new ArrayList<IVMInstall>();
        this.allJREs.addAll(Arrays.asList(compat));
        IVMInstall[] allFromUtil = VMInstallUtil.getAllVMInstalls();
        ArrayList<IVMInstall> noncompliant = new ArrayList<IVMInstall>();
        noncompliant.addAll(Arrays.asList(allFromUtil));
        noncompliant.removeAll(Arrays.asList(compat));
        this.allJREs.addAll(noncompliant);
        List<IVMInstall> toDisplay = this.getDisplayableJREList();
        this.jreNames = new String[toDisplay.size()];
        int i2 = 0;
        while (i2 < toDisplay.size()) {
            this.jreNames[i2] = toDisplay.get(i2).getName();
            ++i2;
        }
    }

    protected List<IVMInstall> getDisplayableJREList() {
        return this.includeIncompatibleJREs() ? this.allJREs : this.compatibleJREs;
    }

    protected boolean includeIncompatibleJREs() {
        return true;
    }

    protected IExecutionEnvironment[] findAllValidEnvironments(IExecutionEnvironment env) {
        IExecutionEnvironment[] all = EnvironmentsManager.getDefault().getExecutionEnvironments();
        ArrayList<IExecutionEnvironment> toReturn = new ArrayList<IExecutionEnvironment>();
        toReturn.add(env);
        int i = 0;
        while (i < all.length) {
            IVMInstall[] vms;
            IExecutionEnvironment[] sub = all[i].getSubEnvironments();
            if (Arrays.asList(sub).contains(env) && !toReturn.contains(all[i]) && (vms = all[i].getCompatibleVMs()).length > 0) {
                toReturn.add(all[i]);
            }
            ++i;
        }
        return toReturn.toArray(new IExecutionEnvironment[toReturn.size()]);
    }

    protected void createWidgets() {
        this.installedJREGroup = new Group((Composite)this, 0);
        this.installedJREGroup.setText(Messages.wf_JRELabel);
        this.installedJREGroup.setLayout((Layout)new GridLayout(3, true));
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        GridData buttonData = new GridData();
        buttonData.grabExcessHorizontalSpace = true;
        buttonData.horizontalAlignment = 4;
        this.execenvRadio = new Button((Composite)this.installedJREGroup, 16);
        this.execenvRadio.setText("Execution Environment: ");
        this.execEnvironmentCombo = new Combo((Composite)this.installedJREGroup, 12);
        this.execEnvironmentCombo.setLayoutData((Object)comboData);
        this.environmentsButton = new Button((Composite)this.installedJREGroup, 0);
        this.environmentsButton.setText("Environments...");
        this.vmRadio = new Button((Composite)this.installedJREGroup, 16);
        this.vmRadio.setText("Alternate JRE: ");
        this.alternateJRECombo = new Combo((Composite)this.installedJREGroup, 12);
        this.alternateJRECombo.setLayoutData((Object)comboData);
        this.installedJREsButton = new Button((Composite)this.installedJREGroup, 0);
        this.installedJREsButton.setText("Installed JREs...");
        this.environmentsButton.setLayoutData((Object)buttonData);
        this.installedJREsButton.setLayoutData((Object)buttonData);
    }

    protected void jreButtonPressed() {
        this.showPreferencePage(JRE_PREF_PAGE_PATH);
        this.execEnvironmentCombo.removeModifyListener(this.comboModifyListener);
        this.alternateJRECombo.removeModifyListener(this.comboModifyListener);
        this.loadModel();
        this.refreshWidgets();
        this.execEnvironmentCombo.addModifyListener(this.comboModifyListener);
        this.alternateJRECombo.addModifyListener(this.comboModifyListener);
        this.vmChanged();
    }

    @Deprecated
    protected boolean showPreferencePage() {
        return this.showPreferencePage(JRE_PREF_PAGE_PATH);
    }

    private void vmChanged() {
        int vmIndex = !this.vmRadio.getSelection() ? -1 : this.alternateJRECombo.getSelectionIndex();
        this.selectedVM = vmIndex == -1 ? null : this.getDisplayableJREList().get(vmIndex);
        int execenvIndex = !this.execenvRadio.getSelection() ? -1 : this.execEnvironmentCombo.getSelectionIndex();
        IExecutionEnvironment iExecutionEnvironment = this.selectedExecutionEnvironment = execenvIndex == -1 ? null : this.validExecutionEnvironments[execenvIndex];
        if (this.listener != null) {
            this.listener.vmChanged(this);
        }
    }

    protected abstract IRuntime getRuntimeFromTaskModel();

    public abstract IExecutionEnvironment getMinimumExecutionEnvironment();

    public abstract IExecutionEnvironment getStoredExecutionEnvironment();

    public IExecutionEnvironment getSelectedExecutionEnvironment() {
        return this.selectedExecutionEnvironment;
    }

    protected abstract IVMInstall getStoredJRE();

    public IVMInstall getSelectedVM() {
        return this.selectedVM;
    }

    public boolean selectedVMisCompatible() {
        return this.selectedVM == null || this.compatibleJREs.contains(this.selectedVM);
    }

    public abstract List<IVMInstall> getValidJREs();

    protected boolean showPreferencePage(String pageId) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find(pageId);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.setSelectedNode(pageId);
        dialog.create();
        dialog.setMessage(node.getLabelText());
        return dialog.open() == 0;
    }
}

