/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class VMInstallUtil {
    private static final Pattern MAJOR_MINOR_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\..*");
    private static final boolean PREFER_HIGHEST = true;
    private static final boolean PREFER_LOWEST = false;

    public static IVMInstall findVMInstall(String type, String id) {
        if (type != null && id != null) {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)type);
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int i = 0;
            while (i < vmInstalls.length) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IVMInstall[] getAllVMInstalls() {
        ArrayList<IVMInstall> allRet = new ArrayList<IVMInstall>();
        IVMInstallType[] allTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < allTypes.length) {
            IVMInstallType vmInstallType = allTypes[i];
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int j = 0;
            while (j < vmInstalls.length) {
                allRet.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        return allRet.toArray(new IVMInstall[allRet.size()]);
    }

    public static IVMInstall findVMInstall(IExecutionEnvironment environment) {
        return VMInstallUtil.findVMInstall(environment, false);
    }

    private static IVMInstall findVMInstall(IExecutionEnvironment environment, boolean preference) {
        if (environment != null) {
            List<IVMInstall2> sorted;
            IVMInstall[] installs = environment.getCompatibleVMs();
            if (environment.getDefaultVM() != null) {
                return environment.getDefaultVM();
            }
            int i = 0;
            while (i < installs.length) {
                IVMInstall install = installs[i];
                if (environment.isStrictlyCompatible(install)) {
                    return install;
                }
                ++i;
            }
            IVMInstall workspaceDefault = JavaRuntime.getDefaultVMInstall();
            if (installs != null && workspaceDefault != null) {
                int i2 = 0;
                while (i2 < installs.length) {
                    if (workspaceDefault.equals(installs[i2])) {
                        return workspaceDefault;
                    }
                    ++i2;
                }
            }
            if ((sorted = VMInstallUtil.sortVMs(installs)).size() > 0) {
                if (!preference) {
                    return (IVMInstall)sorted.get(0);
                }
                if (preference) {
                    return (IVMInstall)sorted.get(sorted.size() - 1);
                }
            }
            if (installs != null && installs.length > 0 && installs[0] != null) {
                return installs[0];
            }
        }
        IVMInstall i = environment == null ? null : environment.getDefaultVM();
        return i == null ? JavaRuntime.getDefaultVMInstall() : i;
    }

    private static List<IVMInstall2> sortVMs(IVMInstall[] installs) {
        ArrayList<IVMInstall2> all = new ArrayList<IVMInstall2>();
        int i = 0;
        while (i < installs.length) {
            String version;
            if (installs[i] instanceof IVMInstall2 && (version = ((IVMInstall2)installs[i]).getJavaVersion()) != null) {
                try {
                    VMInstallUtil.getMajorMinor(version);
                    all.add((IVMInstall2)installs[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++i;
        }
        Collections.sort(all, new Comparator<IVMInstall2>(){

            @Override
            public int compare(IVMInstall2 o1, IVMInstall2 o2) {
                String arg0vers = o1.getJavaVersion();
                String arg1vers = o2.getJavaVersion();
                return VMInstallUtil.compareJavaVersions(arg0vers, arg1vers);
            }
        });
        return all;
    }

    private static int compareJavaVersions(String version0, String version1) {
        int[] arg1majorMinor;
        int[] arg0majorMinor = VMInstallUtil.getMajorMinor(version0);
        if (arg0majorMinor[0] < (arg1majorMinor = VMInstallUtil.getMajorMinor(version1))[0]) {
            return -1;
        }
        if (arg0majorMinor[0] > arg1majorMinor[0]) {
            return 1;
        }
        if (arg0majorMinor[1] < arg1majorMinor[1]) {
            return -1;
        }
        if (arg0majorMinor[1] > arg1majorMinor[1]) {
            return 1;
        }
        return 0;
    }

    private static int[] getMajorMinor(String version) {
        Matcher m = MAJOR_MINOR_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version string");
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }
}

