/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public abstract class ProcessTerminatedDebugListener
implements IDebugEventSetListener {
    private IProcess myProcess;
    private IServer server;

    public ProcessTerminatedDebugListener(IServer server, IProcess process) {
        this.myProcess = process;
        this.server = server;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (events != null) {
            int size = events.length;
            int i = 0;
            while (i < size) {
                if (this.myProcess != null && this.myProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                    this.handleProcessTerminatedEvent(this);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessTerminatedEvent(ProcessTerminatedDebugListener listener) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.server);
        IProcess sharedProcess = (IProcess)beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
        ProcessTerminatedDebugListener processTerminatedDebugListener = this;
        synchronized (processTerminatedDebugListener) {
            if (sharedProcess != null && !sharedProcess.equals(this.myProcess)) {
                return;
            }
            if (this.server.getServerState() != 4) {
                this.handleEarlyTermination();
            }
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)listener);
        }
        if (this.server.getServerState() != 4) {
            ((ControllableServerBehavior)ProcessTerminatedDebugListener.getServerBehavior(this.server)).setServerStopped();
        }
    }

    protected abstract void handleEarlyTermination();

    protected static IControllableServerBehavior getServerBehavior(ILaunchConfiguration configuration) throws CoreException {
        return ProcessTerminatedDebugListener.getServerBehavior(ServerUtil.getServer((ILaunchConfiguration)configuration));
    }

    protected static IControllableServerBehavior getServerBehavior(IServer server) {
        IControllableServerBehavior behavior = (IControllableServerBehavior)server.getAdapter(IControllableServerBehavior.class);
        return behavior;
    }
}

