/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.wtp.core.Messages;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.ServerHotCodeReplaceListener;

public abstract class AbstractJavaServerLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    protected void fireVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null && "profile".equals(mode)) {
            runner = vm.getVMRunner("run");
        }
        if (runner == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 0, Messages.runModeNotSupported, null));
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        String[] environment = this.getEnvironment(configuration);
        String mainType = this.getMainTypeName(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainType, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setEnvironment(environment);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("profile".equals(mode)) {
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
                ServerBehaviourDelegate jbsb = (ServerBehaviourDelegate)server.getAdapter(ServerBehaviourDelegate.class);
                jbsb.stop(true);
                throw ce;
            }
        }
        runner.run(runConfig, launch, monitor);
        this.overrideHotcodeReplace(configuration, launch);
    }

    protected boolean overrideHotcodeReplace(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        IJavaHotCodeReplaceListener l = this.getHotCodeReplaceListener(ServerUtil.getServer((ILaunchConfiguration)configuration), launch);
        if (l != null) {
            IDebugTarget[] targets = launch.getDebugTargets();
            if (targets != null && l != null) {
                int i = 0;
                while (i < targets.length) {
                    if (targets[i] instanceof IJavaDebugTarget) {
                        ((IJavaDebugTarget)targets[i]).addHotCodeReplaceListener(l);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean addCustomHotcodeReplaceLogic(IServer server) {
        return server.getAttribute("org.jboss.ide.eclipse.as.wtp.core.server.launch.OverrideHotCodeReplace", false);
    }

    protected IJavaHotCodeReplaceListener getHotCodeReplaceListener(IServer server, ILaunch launch) {
        if (this.addCustomHotcodeReplaceLogic(server)) {
            return new ServerHotCodeReplaceListener(server, launch);
        }
        return null;
    }
}

