/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.IDelegatingServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;

public class JBossServerBehaviorUtils {
    public static IDelegatingServerBehavior getServerBehavior(ILaunchConfiguration configuration) {
        try {
            IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
            return (IDelegatingServerBehavior)server.getAdapter(IDelegatingServerBehavior.class);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IControllableServerBehavior getControllableBehavior(ILaunchConfiguration configuration) throws CoreException {
        return JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)ServerUtil.getServer((ILaunchConfiguration)configuration));
    }

    public static IControllableServerBehavior getControllableBehavior(IServerAttributes server) {
        IControllableServerBehavior behavior = (IControllableServerBehavior)server.getAdapter(IControllableServerBehavior.class);
        if (behavior == null) {
            behavior = (IControllableServerBehavior)server.loadAdapter(IControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return behavior;
    }

    public static <T> T getController(IServerAttributes server, String id, Class<T> clazz) throws CoreException {
        ISubsystemController controller;
        IControllableServerBehavior behavior = JBossServerBehaviorUtils.getControllableBehavior(server);
        if (behavior != null && (controller = behavior.getController(id)) != null && clazz.isAssignableFrom(controller.getClass())) {
            return (T)controller;
        }
        return null;
    }
}

