/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;

public class ServerBeanTypeEAP
extends JBossServerType {
    private static final String TWIDDLE_JAR_NAME = "twiddle.jar";

    public ServerBeanTypeEAP() {
        super("EAP", "Enterprise Application Platform", ServerBeanTypeEAP.asPath("jboss-as", "bin", TWIDDLE_JAR_NAME), new String[]{"4.2", "4.3", "5.0", "5.1"}, new EAPServerTypeCondition());
    }

    @Override
    public String getRootToAdapterRelativePath(String version) {
        return "jboss-as";
    }

    public static abstract class AbstractEAPTypeCondition
    extends AbstractCondition {
        @Override
        public String getServerTypeId(String version) {
            if ("4.2".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.43";
            }
            if ("4.3".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.43";
            }
            if ("5.0".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.50";
            }
            if ("5.1".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.50";
            }
            if ("5.2".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.50";
            }
            if ("5.3".equals(version)) {
                return "org.jboss.ide.eclipse.as.eap.50";
            }
            return null;
        }
    }

    public static class EAPServerTypeCondition
    extends AbstractEAPTypeCondition {
        @Override
        public boolean isServerRoot(File location) {
            File asSystemJar = new File(location, JBossServerType.EAP.getSystemJarPath());
            return asSystemJar.exists() && asSystemJar.isFile();
        }
    }
}

