/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanTypeUnknown;
import org.jboss.ide.eclipse.as.core.server.jbossmodules.LayeredModulePathFactory;
import org.jboss.ide.eclipse.as.core.util.FileUtil;

public class ServerBeanType {
    protected static final String UNKNOWN_STR = "UNKNOWN";
    public static final ServerBeanType UNKNOWN = new ServerBeanTypeUnknown();
    protected String name;
    protected String systemJarPath;
    protected ICondition condition = null;
    protected String id = "UNKNOWN";

    protected ServerBeanType(String id, String name, String systemJarPath, ICondition condition) {
        this.id = id;
        this.name = name;
        this.systemJarPath = systemJarPath;
        this.condition = condition;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSystemJarPath() {
        return this.systemJarPath;
    }

    public boolean isServerRoot(File location) {
        return this.condition.isServerRoot(location);
    }

    public String getFullVersion(File root) {
        if (this.condition == null) {
            return null;
        }
        return this.condition.getFullVersion(root, new File(root, this.getSystemJarPath()));
    }

    public String getUnderlyingTypeId(File root) {
        if (this.condition == null) {
            return null;
        }
        String ret = null;
        if (this.condition instanceof AbstractCondition) {
            ret = ((AbstractCondition)this.condition).getUnderlyingTypeId(root, new File(root, this.getSystemJarPath()));
        }
        return ret == null ? this.id : ret;
    }

    public String getServerAdapterTypeId(String version) {
        return this.condition == null ? null : this.condition.getServerTypeId(version);
    }

    public String getRootToAdapterRelativePath(String version) {
        return null;
    }

    /*
     * Loose catch block
     */
    protected static Properties loadProperties(File f) {
        Properties properties;
        FileInputStream stream;
        Properties p;
        block11: {
            p = new Properties();
            stream = null;
            stream = new FileInputStream(f);
            p.load(stream);
            properties = p;
            if (stream == null) break block11;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
        catch (IOException iOException) {
            Properties properties2;
            block12: {
                try {
                    properties2 = p;
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException3) {}
            }
            return properties2;
        }
    }

    protected static String asPath(String ... vals) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            sb.append(v);
            sb.append(File.separatorChar);
            ++n2;
        }
        String s = sb.toString();
        s = s.substring(0, s.length() - 1);
        return s;
    }

    protected static boolean scanFolderJarsForManifestProp(File location, String mainFolder, String property, String propPrefix) {
        String value = ServerBeanType.getManifestPropFromFolderJars(location, mainFolder, property);
        return value != null && value.trim().startsWith(propPrefix);
    }

    protected static String getManifestPropFromFolderJars(File location, String mainFolder, String property) {
        File f = new File(location, mainFolder);
        if (f.exists()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                if (children[i].getName().endsWith(".jar")) {
                    return ServerBeanType.getJarProperty(children[i], property);
                }
                ++i;
            }
        }
        return null;
    }

    protected static boolean scanManifestPropFromJBossModulesFolder(File[] moduleRoots, String moduleId, String slot, String property, String propPrefix) {
        String value = ServerBeanType.getManifestPropFromJBossModulesFolder(moduleRoots, moduleId, slot, property);
        return value != null && value.trim().startsWith(propPrefix);
    }

    protected static String getManifestPropFromJBossModulesFolder(File[] moduleRoots, String moduleId, String slot, String property) {
        File[] layeredRoots = LayeredModulePathFactory.resolveLayeredModulePath(moduleRoots);
        int i = 0;
        while (i < layeredRoots.length) {
            IPath[] manifests = ServerBeanType.getFilesForModule(layeredRoots[i], moduleId, slot, ServerBeanType.manifestFilter());
            if (manifests.length > 0) {
                String value = ServerBeanType.getManifestProperty(manifests[0].toFile(), property);
                if (value != null) {
                    return value;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    protected static boolean scanManifestPropFromJBossModules(File[] moduleRoots, String moduleId, String slot, String property, String propPrefix) {
        String value = ServerBeanType.getManifestPropFromJBossModules(moduleRoots, moduleId, slot, property);
        return value != null && value.trim().startsWith(propPrefix);
    }

    protected static String getManifestPropFromJBossModules(File[] moduleRoots, String moduleId, String slot, String property) {
        File[] layeredRoots = LayeredModulePathFactory.resolveLayeredModulePath(moduleRoots);
        int i = 0;
        while (i < layeredRoots.length) {
            IPath[] jars = ServerBeanType.getFilesForModule(layeredRoots[i], moduleId, slot, ServerBeanType.jarFilter());
            if (jars.length > 0) {
                String value = ServerBeanType.getJarProperty(jars[0].toFile(), property);
                return value;
            }
            ++i;
        }
        return null;
    }

    private static FileFilter jarFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        };
    }

    private static FileFilter manifestFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().equals("manifest.mf");
            }
        };
    }

    private static IPath[] getFilesForModule(File modulesFolder, String moduleName, String slot, FileFilter filter) {
        String slashed = moduleName.replaceAll("\\.", "/");
        slot = slot == null ? "main" : slot;
        return ServerBeanType.getFiles(modulesFolder, new Path(slashed).append(slot), filter);
    }

    private static IPath[] getFiles(File modulesFolder, IPath moduleRelativePath, FileFilter filter) {
        File[] layeredPaths = LayeredModulePathFactory.resolveLayeredModulePath(modulesFolder);
        int i = 0;
        while (i < layeredPaths.length) {
            Path lay = new Path(layeredPaths[i].getAbsolutePath());
            File layeredPath = new File(lay.append(moduleRelativePath).toOSString());
            if (layeredPath.exists()) {
                return ServerBeanType.getFilesFrom(layeredPath, filter);
            }
            ++i;
        }
        return new IPath[0];
    }

    private static IPath[] getFilesFrom(File layeredPath, FileFilter filter) {
        ArrayList<Path> list = new ArrayList<Path>();
        File[] children = layeredPath.listFiles();
        int i = 0;
        while (i < children.length) {
            if (filter.accept(children[i])) {
                list.add(new Path(children[i].getAbsolutePath()));
            }
            ++i;
        }
        return list.toArray(new IPath[list.size()]);
    }

    /*
     * Loose catch block
     */
    public static String getJarProperty(File systemJarFile, String propertyName) {
        if (systemJarFile.canRead()) {
            String string;
            ZipFile jar;
            block12: {
                String value;
                jar = null;
                jar = new ZipFile(systemJarFile);
                ZipEntry manifest = jar.getEntry("META-INF/MANIFEST.MF");
                Properties props = new Properties();
                props.load(jar.getInputStream(manifest));
                string = value = (String)props.get(propertyName);
                if (jar == null) break block12;
                try {
                    jar.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return string;
            catch (IOException iOException) {
                block13: {
                    try {
                        if (jar == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException iOException2) {
                                return null;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        jar.close();
                    }
                    catch (IOException iOException3) {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static String getManifestProperty(File manifestFile, String propertyName) {
        try {
            String contents = FileUtil.getContents(manifestFile);
            if (contents != null) {
                Manifest mf = new Manifest(new ByteArrayInputStream(contents.getBytes()));
                Attributes a = mf.getMainAttributes();
                String val = a.getValue(propertyName);
                return val;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public String getServerBeanName(File root) {
        return root.getName();
    }
}

