/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IImportProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class NewProjectExamplesJob
extends WorkspaceJob {
    private static final String WORKING_SETS = "workingSets";
    private List<ProjectExampleWorkingCopy> selectedProjects;
    private List<ProjectExampleWorkingCopy> projects = new ArrayList<ProjectExampleWorkingCopy>();
    private IWorkingSet[] workingSets;
    private Map<String, Object> propertiesMap;

    public NewProjectExamplesJob(String name, List<ProjectExampleWorkingCopy> selectedProjects, IWorkingSet[] workingSets, Map<String, Object> propertiesMap) {
        super(name);
        this.selectedProjects = selectedProjects;
        this.workingSets = workingSets;
        this.propertiesMap = propertiesMap;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        this.projects.clear();
        for (ProjectExampleWorkingCopy selectedProject : this.selectedProjects) {
            boolean success = ProjectExamplesActivator.downloadProject(selectedProject, monitor);
            if (success) {
                this.projects.add(selectedProject);
                continue;
            }
            final String message = "Unable to download the '" + selectedProject.getName() + "' quickstart.\r\nPlease check your Internet connection and/or Proxy Settings";
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)NewProjectExamplesJob.this.getShell(), (String)"Error", (String)message);
                }
            });
            return Status.CANCEL_STATUS;
        }
        try {
            this.setName(Messages.NewProjectExamplesWizard_Importing);
            for (final ProjectExampleWorkingCopy project : this.projects) {
                Object object;
                IImportProjectExample importProjectExample = ProjectExamplesActivator.getDefault().getImportProjectExample(project.getImportType());
                if (importProjectExample == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle.openError((Shell)NewProjectExamplesJob.this.getShell(), (String)Messages.NewProjectExamplesWizard_Error, (String)("Cannot import a project of the '" + project.getImportType() + "' type."));
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (!importProjectExample.importProject(project, project.getFile(), this.propertiesMap, monitor)) {
                    return Status.CANCEL_STATUS;
                }
                UsageEventType createProjectEvent = ProjectExamplesActivator.getDefault().getCreateProjectFromExampleEventType();
                UsageReporter.getInstance().trackEvent(createProjectEvent.event(project.getId()));
                importProjectExample.fix(project, monitor);
                ProjectExamplesActivator.fixWelcome(project);
                if ((this.workingSets == null || this.workingSets.length == 0) && this.propertiesMap != null && (object = this.propertiesMap.get(WORKING_SETS)) instanceof List) {
                    List list = (List)object;
                    this.workingSets = list.toArray(new IWorkingSet[0]);
                }
                if (this.workingSets == null || this.workingSets.length <= 0 || project.getIncludedProjects() == null) continue;
                for (String projectName : project.getIncludedProjects()) {
                    IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (eclipseProject == null || !eclipseProject.exists()) continue;
                    PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)eclipseProject, this.workingSets);
                }
            }
        }
        catch (Exception e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle.openError((Shell)NewProjectExamplesJob.this.getShell(), (String)Messages.NewProjectExamplesWizard_Error, (String)e.getMessage(), (String)Messages.NewProjectExamplesWizard_Detail, (boolean)false, (IPreferenceStore)ProjectExamplesActivator.getDefault().getPreferenceStore(), (String)"errorDialog");
                }
            });
            ProjectExamplesActivator.log(e);
        }
        return Status.OK_STATUS;
    }

    protected Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public List<ProjectExampleWorkingCopy> getProjects() {
        return this.projects;
    }
}

