/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.model.ProjectExampleCategoryParser;
import org.jboss.tools.project.examples.internal.model.ProjectExampleJaxbParser;
import org.jboss.tools.project.examples.internal.model.ProjectExampleSiteParser;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.offline.OfflineUtil;

public class ProjectExampleUtil {
    private static final String SERVER_PROJECT_EXAMPLE_XML = ".project_example.xml";
    private static final String URL = "url";
    public static final String EDITOR = "editor";
    public static final String CHEATSHEETS = "cheatsheets";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_PLATFORM = "platform";
    private static final String PROJECT_EXAMPLES_XML_EXTENSION_ID = "org.jboss.tools.project.examples.projectExamplesXml";
    private static final String PROJECT_EXAMPLES_CATEGORIES_EXTENSION_ID = "org.jboss.tools.project.examples.categories";
    private static final int TIME_OUT = 2000;
    private static String URL_EXT = "url";
    private static String URL_KEY = "urlKey";
    private static String EXPERIMENTAL_EXT = "experimental";
    private static Set<IProjectExampleSite> pluginSites;
    private static HashSet<IProjectExampleSite> invalidSites;
    private static Set<URI> categoryUris;

    static {
        invalidSites = new HashSet();
    }

    private ProjectExampleUtil() {
    }

    public static Set<IProjectExampleSite> getPluginSites() {
        if (pluginSites == null) {
            IExtension[] extensions;
            pluginSites = new HashSet<IProjectExampleSite>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PROJECT_EXAMPLES_XML_EXTENSION_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                ProjectExampleSite site = new ProjectExampleSite();
                site.setName(extension.getLabel());
                String urlKey = null;
                String urlValue = null;
                IConfigurationElement[] iConfigurationElementArray = configurationElements;
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (URL_KEY.equals(configurationElement.getName())) {
                        urlKey = configurationElement.getValue();
                    }
                    if (URL_EXT.equals(configurationElement.getName())) {
                        urlValue = configurationElement.getValue();
                    } else if (EXPERIMENTAL_EXT.equals(configurationElement.getName())) {
                        String experimental = configurationElement.getValue();
                        site.setExperimental(Boolean.parseBoolean(experimental));
                    }
                    ++n4;
                }
                String urlString = urlValue;
                if (urlKey != null) {
                    urlString = PropertiesHelper.getPropertiesProvider().getValue(urlKey, urlValue);
                }
                URI url = ProjectExampleUtil.getURI(urlString);
                site.setUrl(url);
                if (site.getUrl() != null) {
                    pluginSites.add(site);
                }
                ++n2;
            }
        }
        return pluginSites;
    }

    public static Set<IProjectExampleSite> getRuntimeSites() {
        return ProjectExampleUtil.getRuntimeSites(false);
    }

    public static Set<IProjectExampleSite> getRuntimeSites(boolean force) {
        IServer[] servers;
        IPreferenceStore store;
        HashSet<IProjectExampleSite> sites = new HashSet<IProjectExampleSite>();
        if (!force && !(store = ProjectExamplesActivator.getDefault().getPreferenceStore()).getBoolean("showRuntimeSites")) {
            return sites;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IJBossServerRuntime jbossRuntime;
            IServer server = iServerArray[n2];
            IRuntime runtime = server.getRuntime();
            if (runtime != null && (jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                IPath jbossLocation = runtime.getLocation();
                if (jbossRuntime.getRuntime() != null) {
                    String name = String.valueOf(jbossRuntime.getRuntime().getName()) + " Project Examples";
                    File serverHome = jbossLocation.toFile();
                    File file = ProjectExampleUtil.getFile(serverHome, true);
                    if (file != null) {
                        ProjectExampleSite site = new ProjectExampleSite();
                        site.setExperimental(false);
                        site.setName(name);
                        site.setUrl(file.toURI());
                        sites.add(site);
                    }
                }
            }
            ++n2;
        }
        return sites;
    }

    private static File getFile(File serverHome, boolean b) {
        if (!serverHome.isDirectory()) {
            return null;
        }
        File[] directories = serverHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories != null && directories.length > 0) {
            File[] fileArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                File projectExampleFile = new File(directory, SERVER_PROJECT_EXAMPLE_XML);
                if (projectExampleFile.isFile()) {
                    return projectExampleFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Set<IProjectExampleSite> getUserSites() {
        IPreferenceStore store;
        String sitesAsXml;
        LinkedHashSet<IProjectExampleSite> sites = new LinkedHashSet<IProjectExampleSite>();
        ProjectExampleSite site = ProjectExampleUtil.getSite(ProjectExampleUtil.getProjectExamplesXml());
        if (site != null) {
            sites.add(site);
        }
        if ((sitesAsXml = (store = ProjectExamplesActivator.getDefault().getPreferenceStore()).getString("userSites")) != null && !sitesAsXml.trim().isEmpty()) {
            try {
                Set<IProjectExampleSite> userSites = new ProjectExampleSiteParser().parse(sitesAsXml);
                if (userSites != null) {
                    sites.addAll(userSites);
                }
            }
            catch (CoreException e) {
                ProjectExamplesActivator.log("Unable to parse user site preferences ( " + sitesAsXml + ").\r\nException :" + e.getLocalizedMessage());
            }
        }
        return sites;
    }

    private static Set<IProjectExampleSite> getSites() {
        HashSet<IProjectExampleSite> sites = new HashSet<IProjectExampleSite>();
        sites.addAll(ProjectExampleUtil.getPluginSites());
        sites.addAll(ProjectExampleUtil.getUserSites());
        sites.addAll(ProjectExampleUtil.getRuntimeSites());
        return sites;
    }

    public static ProjectExampleSite getSite(String url) {
        if (url != null) {
            ProjectExampleSite site = new ProjectExampleSite();
            try {
                site.setUrl(new URL(url).toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                ProjectExamplesActivator.log(String.valueOf(url) + " is not a valid URL " + e.getMessage());
                return null;
            }
            site.setExperimental(true);
            site.setName(Messages.ProjectUtil_Test);
            return site;
        }
        return null;
    }

    private static URI getURI(String urlString) {
        if (urlString != null && urlString.trim().length() > 0) {
            urlString = urlString.trim();
            try {
                URI url = new URL(urlString).toURI();
                return url;
            }
            catch (MalformedURLException | URISyntaxException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return null;
    }

    @Deprecated
    public static List<ProjectExampleCategory> getCategories(IProgressMonitor monitor) {
        return ProjectExampleUtil.getCategories(ProjectExampleUtil.getSites(), monitor);
    }

    @Deprecated
    public static List<ProjectExampleCategory> getCategories(Set<IProjectExampleSite> sites, IProgressMonitor monitor) {
        Map<String, ProjectExampleCategory> categories;
        block11: {
            monitor.setTaskName(Messages.ProjectUtil_Parsing_project_description_files);
            invalidSites.clear();
            categories = ProjectExampleUtil.fetchCategories(monitor);
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ExecutorCompletionService<Tuple<IProjectExampleSite, List<ProjectExample>>> pool = new ExecutorCompletionService<Tuple<IProjectExampleSite, List<ProjectExample>>>(service);
            try {
                try {
                    boolean showExperimentalSites = ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("showExperimentalSites");
                    int count = 0;
                    for (IProjectExampleSite site : sites) {
                        if (!showExperimentalSites && site.isExperimental()) continue;
                        if (monitor.isCanceled()) {
                            invalidSites.add(site);
                            continue;
                        }
                        pool.submit(new FetchProjectExampleDocumentTask(site));
                        ++count;
                    }
                    int k = 0;
                    while (k < count) {
                        Tuple tuple = (Tuple)pool.take().get();
                        IProjectExampleSite site = (IProjectExampleSite)tuple.key;
                        List examples = (List)tuple.value;
                        if (examples == null) {
                            invalidSites.add(site);
                        } else {
                            for (ProjectExample example : examples) {
                                if (!ProjectExampleUtil.canBeImported(example)) continue;
                                ProjectExampleUtil.addToCategory(example, categories);
                            }
                        }
                        ++k;
                    }
                }
                catch (Exception e) {
                    ProjectExamplesActivator.log(e);
                    service.shutdown();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                service.shutdown();
                throw throwable;
            }
            service.shutdown();
        }
        ArrayList<ProjectExampleCategory> result = new ArrayList<ProjectExampleCategory>(categories.values());
        return result;
    }

    public static void addToCategory(ProjectExample example, Map<String, ProjectExampleCategory> categories) {
        ProjectExampleCategory category;
        String categoryName = example.getCategory();
        if (categoryName == null || categoryName.trim().isEmpty()) {
            categoryName = ProjectExampleCategory.OTHER;
            example.setCategory(categoryName);
        }
        if ((category = categories.get(categoryName)) == null) {
            category = new ProjectExampleCategory(categoryName);
            categories.put(categoryName, category);
        }
        category.getProjects().add(example);
    }

    public static Set<URI> getCategoryURIs() {
        if (categoryUris == null) {
            categoryUris = new HashSet<URI>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PROJECT_EXAMPLES_CATEGORIES_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                String urlKey = null;
                String urlValue = null;
                int j = 0;
                while (j < configurationElements.length) {
                    IConfigurationElement configurationElement = configurationElements[j];
                    if (URL_EXT.equals(configurationElement.getName())) {
                        urlValue = configurationElement.getValue();
                    } else if (URL_KEY.equals(configurationElement.getName())) {
                        urlKey = configurationElement.getValue();
                    }
                    ++j;
                }
                String urlString = PropertiesHelper.getPropertiesProvider().getValue(urlKey, urlValue);
                URI url = ProjectExampleUtil.getURI(urlString);
                if (url != null) {
                    categoryUris.add(url);
                }
                ++i;
            }
        }
        return categoryUris;
    }

    public static Map<String, ProjectExampleCategory> fetchCategories(IProgressMonitor monitor) {
        ArrayList<ProjectExampleCategory> list = new ArrayList<ProjectExampleCategory>();
        Set<URI> urls = ProjectExampleUtil.getCategoryURIs();
        for (URI url : urls) {
            if (monitor.isCanceled()) break;
            File file = null;
            try {
                file = ProjectExampleUtil.getProjectExamplesFile(url.toURL(), "categories", ".xml", monitor);
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
            }
            if (file == null || !file.exists() || !file.isFile()) {
                ProjectExamplesActivator.log(NLS.bind((String)Messages.ProjectUtil_Invalid_URL, (Object)url.toString()));
                continue;
            }
            try {
                List<ProjectExampleCategory> cats = new ProjectExampleCategoryParser().parse(file);
                list.addAll(cats);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(list);
        LinkedHashMap<String, ProjectExampleCategory> categories = new LinkedHashMap<String, ProjectExampleCategory>();
        for (ProjectExampleCategory c : list) {
            categories.put(c.getName(), c);
        }
        return categories;
    }

    private static String getProjectExamplesXml() {
        String projectXML = System.getProperty("org.jboss.tools.project.examples.xml");
        if (projectXML != null && projectXML.length() > 0) {
            return projectXML;
        }
        return null;
    }

    public static File getProjectExamplesFile(URL url, String prefix, String suffix, IProgressMonitor monitor) {
        File file = null;
        if (PROTOCOL_FILE.equals(url.getProtocol()) || PROTOCOL_PLATFORM.equalsIgnoreCase(url.getProtocol())) {
            try {
                file = new File(new URI(url.toExternalForm()));
            }
            catch (Exception exception) {
                file = new File(url.getFile());
            }
            if (!file.exists()) {
                return null;
            }
        } else {
            long urlModified;
            block21: {
                boolean fileAlreadyExists;
                block20: {
                    block19: {
                        block18: {
                            try {
                                if (OfflineUtil.isOfflineEnabled()) {
                                    return OfflineUtil.getOfflineFile(url);
                                }
                                if (!monitor.isCanceled()) break block18;
                                return null;
                            }
                            catch (FileNotFoundException e) {
                                ProjectExamplesActivator.log(e);
                                return null;
                            }
                        }
                        urlModified = -1L;
                        file = ProjectExampleUtil.getFile(url);
                        try {
                            urlModified = new URLTransportUtility().getLastModified(url);
                        }
                        catch (CoreException coreException) {
                            if (!file.exists()) break block19;
                            return file;
                        }
                    }
                    if (file.exists()) {
                        long modified = file.lastModified();
                        if (modified > 0L && (urlModified == 0L || urlModified == modified)) {
                            return file;
                        }
                        if (modified == 0L && urlModified == modified && (file.getName().endsWith("GA.zip") || file.getName().endsWith("Final.zip"))) {
                            return file;
                        }
                    }
                    fileAlreadyExists = file.exists();
                    file.getParentFile().mkdirs();
                    if (!monitor.isCanceled()) break block20;
                    return null;
                }
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(file));
                IStatus result = new URLTransportUtility().download(prefix, url.toExternalForm(), (OutputStream)destination, 2000, monitor);
                if (result.isOK()) break block21;
                ProjectExamplesActivator.getDefault().getLog().log(result);
                if (!fileAlreadyExists && file.exists()) {
                    file.delete();
                }
                return null;
            }
            if (file.exists()) {
                file.setLastModified(urlModified);
            }
        }
        return file;
    }

    private static File getFile(URL url) {
        IPath location = ProjectExamplesActivator.getDefault().getStateLocation();
        File root = location.toFile();
        String urlFile = url.getFile();
        File file = new File(root, urlFile);
        return file;
    }

    public static String getAsXML(Set<IProjectExampleSite> sites) throws CoreException {
        return new ProjectExampleSiteParser().serialize(sites);
    }

    public static HashSet<IProjectExampleSite> getInvalidSites() {
        return invalidSites;
    }

    public static List<ProjectExample> getProjectsByTags(Collection<ProjectExampleCategory> categories, String ... tags) {
        if (categories == null) {
            return null;
        }
        ArrayList<ProjectExample> selection = new ArrayList<ProjectExample>();
        for (ProjectExampleCategory c : categories) {
            for (ProjectExample p : c.getProjects()) {
                if (!p.hasTags(tags) || selection.contains(p)) continue;
                selection.add(p);
            }
        }
        return selection;
    }

    private static boolean canBeImported(ProjectExample project) {
        return ProjectExamplesActivator.getDefault().getImportProjectExample(project.getImportType()) != null;
    }

    public static void setProjectExamplesFile(ProjectExample project, File file) {
        if (project != null) {
            project.setFile(file);
        }
    }

    public static IPath getDefaultExamplesDirectory() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String baseName = "examples";
        IPath dir = Platform.getLocation().append(baseName);
        int i = 2;
        while (root.getContainerForLocation(dir) != null) {
            dir = Platform.getLocation().append(String.valueOf(baseName) + "_" + i);
            ++i;
        }
        return dir;
    }

    private static class FetchProjectExampleDocumentTask
    implements Callable<Tuple<IProjectExampleSite, List<ProjectExample>>> {
        Tuple<IProjectExampleSite, List<ProjectExample>> tuple;

        public FetchProjectExampleDocumentTask(IProjectExampleSite site) {
            this.tuple = new Tuple(site);
        }

        @Override
        public Tuple<IProjectExampleSite, List<ProjectExample>> call() throws Exception {
            URI uri = ((IProjectExampleSite)this.tuple.key).getUrl();
            File file = ProjectExampleUtil.getProjectExamplesFile(uri.toURL(), "projectExamples", ".xml", (IProgressMonitor)new NullProgressMonitor());
            if (file == null || !file.exists() || !file.isFile()) {
                ProjectExamplesActivator.log(NLS.bind((String)Messages.ProjectUtil_Invalid_URL, (Object)uri.toString()));
                return this.tuple;
            }
            try {
                ProjectExampleJaxbParser parser = new ProjectExampleJaxbParser();
                List<ProjectExample> examples = parser.parse(file);
                if (examples != null) {
                    for (ProjectExample project : examples) {
                        project.setSite((IProjectExampleSite)this.tuple.key);
                    }
                    this.tuple.value = examples;
                }
            }
            catch (Exception e) {
                this.tuple.value = null;
                ProjectExamplesActivator.log(e);
            }
            return this.tuple;
        }
    }

    private static class Tuple<X, Y> {
        X key;
        Y value;

        public Tuple(X key) {
            this.key = key;
        }
    }
}

