/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.tools.project.examples.model.RequirementModel;

public class RequirementModelUtil {
    private RequirementModelUtil() {
    }

    public static Collection<RequirementModel> getAsRequirements(Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, RequirementModel> reqMap = new LinkedHashMap<String, RequirementModel>(tags.size());
        for (String tag : tags) {
            RequirementModelUtil.inferRequirement(tag.toLowerCase(), reqMap);
        }
        return reqMap.values();
    }

    private static void inferRequirement(String tag, Map<String, RequirementModel> reqMap) {
        if (tag == null) {
            return;
        }
        String key = null;
        RequirementModel req = null;
        if (tag.contains("hibernate") || tag.contains("jpa")) {
            key = "hibernate";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createHibernateRequirement();
            }
        } else if ("cdi".equals(tag)) {
            key = "cdi";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createMavenCDIRequirement();
            }
        } else if (tag.contains("cordova")) {
            key = "cordova";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createThymRequirement();
            }
        } else if (tag.contains("angular")) {
            key = "angular";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createAngularJsRequirement();
            }
        } else if (tag.contains("drools") || tag.contains("brms")) {
            key = "drools";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createBrmsRequirement();
            }
        } else if (tag.startsWith("product:eap") || tag.startsWith("product:wfk") || tag.equals("jsf") || tag.contains("picketlink")) {
            key = "server";
            if (!reqMap.containsKey(key)) {
                String serverId = null;
                if (tag.startsWith("product:eap")) {
                    if (tag.contains("6.4.")) {
                        serverId = "jbosseap640runtime";
                    } else if (tag.contains("6.3.")) {
                        serverId = "jbosseap630runtime";
                    }
                } else if (tag.startsWith("wfk")) {
                    if (tag.contains("2.7.")) {
                        serverId = "jbosseap640runtime";
                    } else if (tag.contains("2.6.")) {
                        serverId = "jbosseap630runtime";
                    }
                }
                req = RequirementModelUtil.createServerRuntimeRequirement(serverId);
            }
        } else if (tag.contains("fuse")) {
            key = "fuse";
            if (!reqMap.containsKey(key)) {
                req = RequirementModelUtil.createFuseRequirement();
            }
        } else if (tag.startsWith("spring") && !reqMap.containsKey(key = "spring")) {
            req = RequirementModelUtil.createSpringRequirement();
        }
        if (key != null && req != null) {
            reqMap.put(key, req);
        }
    }

    public static RequirementModel createMavenCDIRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.jboss.tools.maven.cdi");
        properties.put("versions", "1.0.0");
        properties.put("description", "Requires the Maven CDI Configurator");
        properties.put("connectorIds", "org.jboss.tools.maven.cdi.feature");
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createSpringRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.springframework.ide.eclipse");
        properties.put("versions", "3.5.0");
        properties.put("description", "Requires Spring IDE");
        properties.put("connectorIds", "org.springframework.ide.eclipse.feature");
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createServerRuntimeRequirement(String serverId) {
        RequirementModel req = RequirementModelUtil.createServerRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("allowed-types", "org.jboss.ide.eclipse.as.runtime.eap.61, org.jboss.ide.eclipse.as.runtime.eap.70, org.jboss.ide.eclipse.as.runtime.wildfly.80,org.jboss.ide.eclipse.as.runtime.wildfly.90");
        properties.put("description", "Requires JBoss EAP 6.2+ or WildFly 8.x/9.x");
        properties.put("downloadId", serverId == null ? "wildfly-820finalruntime" : serverId);
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createAngularJsRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.eclipse.angularjs.core");
        properties.put("versions", "0.8.0");
        properties.put("description", "Requires AngularJS Eclipse Plugin");
        properties.put("connectorIds", "angularjs-eclipse-feature");
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createThymRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.eclipse.thym.core");
        properties.put("versions", "0.1.0");
        properties.put("description", "Requires Eclipse Hybrid Mobile Tools");
        properties.put("connectorIds", "org.jboss.tools.aerogear.hybrid");
        req.setProperties(properties);
        return req;
    }

    private static RequirementModel createPluginRequirement() {
        return new RequirementModel("plugin");
    }

    private static RequirementModel createServerRequirement() {
        return new RequirementModel("wtpruntime");
    }

    public static RequirementModel createFuseRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.eclipse.core.runtime");
        properties.put("versions", "1.0.0");
        properties.put("description", "Requires JBoss Fuse Development Tools");
        properties.put("connectorIds", "jboss.integration-stack.bundle.fuse");
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createBrmsRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.jbpm.eclipse");
        properties.put("versions", "6.0.0");
        properties.put("description", "Requires JBoss Business Process and Rules Development Tools");
        properties.put("connectorIds", "jboss.integration-stack.bundle.bpr");
        req.setProperties(properties);
        return req;
    }

    public static RequirementModel createHibernateRequirement() {
        RequirementModel req = RequirementModelUtil.createPluginRequirement();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", "org.jboss.tools.maven.hibernate");
        properties.put("versions", "1.0.0");
        properties.put("description", "Requires the Maven Hibernate Configurator");
        properties.put("connectorIds", "org.jboss.tools.maven.hibernate.feature");
        req.setProperties(properties);
        return req;
    }
}

