/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.fixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.project.examples.fixes.IProjectFixProvider;
import org.jboss.tools.project.examples.fixes.UIHandler;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.fixes.UnsupportedFixProvider;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.model.RequirementModel;

public class ProjectFixManager {
    private static final IProjectFixProvider UNSUPPORTED_FIX_PROVIDER = new UnsupportedFixProvider();

    public void fix(ProjectExample example, IProgressMonitor monitor) {
        List<IProjectExamplesFix> fixes = ((ProjectExampleWorkingCopy)example).getFixes();
        if (fixes == null || fixes.isEmpty()) {
            List<RequirementModel> reqs = example.getRequirements();
            if (reqs == null || reqs.isEmpty()) {
                return;
            }
            fixes = new ArrayList<IProjectExamplesFix>(reqs.size());
            Map<String, IProjectFixProvider> fixProviders = ProjectFixManager.getFixProviders();
            for (RequirementModel requirement : reqs) {
                if (monitor.isCanceled()) {
                    return;
                }
                IProjectExamplesFix fix = this.getFix(example, requirement, fixProviders);
                if (fix == null) continue;
                fixes.add(fix);
            }
        }
        this.fix(fixes, monitor);
    }

    protected void fix(Collection<IProjectExamplesFix> fixes, IProgressMonitor monitor) {
        for (IProjectExamplesFix fix : fixes) {
            if (monitor.isCanceled()) {
                return;
            }
            fix.fix(monitor);
        }
    }

    public IProjectExamplesFix getFix(ProjectExample example, RequirementModel requirement) {
        return this.getFix(example, requirement, ProjectFixManager.getFixProviders());
    }

    protected IProjectExamplesFix getFix(ProjectExample example, RequirementModel requirement, Map<String, IProjectFixProvider> fixProviders) {
        Assert.isNotNull((Object)requirement);
        return this.getFixProvider(requirement.getType(), fixProviders).create(example, requirement);
    }

    public UIHandler getUIHandler(IProjectExamplesFix fix) {
        Assert.isNotNull((Object)fix);
        return this.getFixProvider(fix.getType()).createUIHandler();
    }

    public void loadFixes(ProjectExampleWorkingCopy workingCopy) {
        if (workingCopy == null || workingCopy.getRequirements() == null || workingCopy.getRequirements().isEmpty()) {
            return;
        }
        List<RequirementModel> reqs = workingCopy.getRequirements();
        if (reqs == null || reqs.isEmpty()) {
            return;
        }
        ArrayList<IProjectExamplesFix> fixes = new ArrayList<IProjectExamplesFix>(reqs.size());
        Map<String, IProjectFixProvider> providers = ProjectFixManager.getFixProviders();
        for (RequirementModel req : reqs) {
            IProjectExamplesFix fix = this.getFix(workingCopy, req, providers);
            if (fix == null) continue;
            fixes.add(fix);
        }
        workingCopy.setFixes(fixes);
    }

    private IProjectFixProvider getFixProvider(String type) {
        return this.getFixProvider(type, ProjectFixManager.getFixProviders());
    }

    private IProjectFixProvider getFixProvider(String type, Map<String, IProjectFixProvider> fixProviders) {
        IProjectFixProvider provider = fixProviders.get(type);
        return provider == null ? UNSUPPORTED_FIX_PROVIDER : provider;
    }

    private static Map<String, IProjectFixProvider> getFixProviders() {
        IExtension[] extensions;
        HashMap<String, IProjectFixProvider> providers = new HashMap<String, IProjectFixProvider>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.jboss.tools.project.examples.projectFixProvider");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String type = element.getAttribute("type");
                if (type != null && !type.isEmpty()) {
                    try {
                        IProjectFixProvider provider = (IProjectFixProvider)element.createExecutableExtension("class");
                        providers.put(type, provider);
                    }
                    catch (CoreException e) {
                        ProjectExamplesActivator.log("Unable to instanciate fixProvider for type " + type + " : " + e.getLocalizedMessage());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return providers;
    }
}

