/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.fixes;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizardDialog;
import org.jboss.tools.project.examples.fixes.AbstractUIHandler;
import org.jboss.tools.project.examples.fixes.IDownloadRuntimeProvider;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.wizard.DownloadRuntimesTaskWizard;

public abstract class AbstractRuntimeFixUIHandler
extends AbstractUIHandler {
    @Override
    public void decorateDownloadButton(Button button, IProjectExamplesFix fix, IProgressMonitor monitor) {
        if (!(fix instanceof IDownloadRuntimeProvider) || button.isDisposed()) {
            return;
        }
        super.decorateDownloadButton(button, fix, monitor);
        IDownloadRuntimeProvider runtimeFix = (IDownloadRuntimeProvider)((Object)fix);
        ArrayList<DownloadRuntime> downloadRuntimes = new ArrayList<DownloadRuntime>(runtimeFix.getDownloadRuntimes(monitor));
        if (!downloadRuntimes.isEmpty()) {
            StringBuilder tooltip = new StringBuilder("Download and install ");
            if (downloadRuntimes.size() > 1) {
                tooltip.append("a runtime");
            } else {
                tooltip.append(((DownloadRuntime)downloadRuntimes.get(0)).getName());
            }
            button.setToolTipText(tooltip.toString());
        }
    }

    @Override
    public void handleInstallRequest(Shell shell, IRunnableContext context, IProjectExamplesFix fix) {
        this.openPreferencesPage(shell, this.getPreferencePageId());
    }

    protected abstract String getPreferencePageId();

    protected void openPreferencesPage(Shell shell, String preferenceId) {
        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferenceId, null, null);
        preferenceDialog.open();
    }

    @Override
    public void handleDownloadRequest(Shell shell, IRunnableContext context, IProjectExamplesFix fix) {
        IDownloadRuntimeProvider runtimeFix = (IDownloadRuntimeProvider)((Object)fix);
        ArrayList<DownloadRuntime> runtimes = new ArrayList<DownloadRuntime>(runtimeFix.getDownloadRuntimes((IProgressMonitor)new NullProgressMonitor()));
        TaskWizardDialog dialog = new TaskWizardDialog(shell, (IWizard)new DownloadRuntimesTaskWizard(runtimes));
        dialog.open();
    }
}

