/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wst.sse.ui.StructuredTextInvocationContext;
import org.eclipse.wst.sse.ui.internal.correction.CompoundQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistry;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.quickfix.QuickFixManager;
import org.jboss.tools.common.quickfix.QuickFixProposal;

public class MarkerAnnotationInfo {
    public static final String UNKNOWN_TAG = "Unknown tag";
    public static final String MISSING_ATTRIBUTE = "Missing required attribute";
    public static final String PREFERENCE_KEY_ATTRIBUTE_NAME = "preference_key";
    public static final String MESSAGE_TYPE_ATTRIBUTE_NAME = "jbt.type";
    public final List<AnnotationInfo> infos;
    public final ISourceViewer viewer;
    private CompoundQuickAssistProcessor fCompoundQuickAssistProcessor = new CompoundQuickAssistProcessor();

    public MarkerAnnotationInfo(List<AnnotationInfo> infos, ISourceViewer textViewer) {
        this.infos = infos;
        this.viewer = textViewer;
    }

    public List<ICompletionProposal> getCompletionProposals(AnnotationInfo info) {
        ArrayList<String> proposalNames = new ArrayList<String>();
        proposalNames.add(XMLUIMessages.SurroundWithNewElementQuickAssistProposal_1);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Annotation annotation : info.getAnnotations()) {
            if (annotation instanceof SimpleMarkerAnnotation) {
                for (ICompletionProposal proposal : this.getMarkerProposals((SimpleMarkerAnnotation)annotation, info.getPosition())) {
                    if (proposalNames.contains(proposal.getDisplayString())) continue;
                    proposals.add(proposal);
                    proposalNames.add(proposal.getDisplayString());
                }
                continue;
            }
            if (!(annotation instanceof TemporaryAnnotation)) continue;
            for (ICompletionProposal proposal : this.getProposals((TemporaryAnnotation)annotation, info.getPosition())) {
                if (proposalNames.contains(proposal.getDisplayString())) continue;
                proposals.add(proposal);
                proposalNames.add(proposal.getDisplayString());
            }
        }
        return proposals;
    }

    private static boolean isJBTAnnotation(Annotation annotation) {
        TemporaryAnnotation ta;
        boolean isJBTAnnotation = false;
        if (annotation instanceof SimpleMarkerAnnotation) {
            SimpleMarkerAnnotation sa = (SimpleMarkerAnnotation)annotation;
            if (sa.getMarker() != null && sa.getMarker().exists()) {
                try {
                    isJBTAnnotation = sa.getMarker().getAttribute(PREFERENCE_KEY_ATTRIBUTE_NAME) != null;
                }
                catch (CoreException e) {
                    CommonPlugin.getDefault().logError(e);
                }
            }
        } else if (annotation instanceof TemporaryAnnotation && (ta = (TemporaryAnnotation)annotation).getAttributes() != null) {
            String attribute = (String)ta.getAttributes().get(MESSAGE_TYPE_ATTRIBUTE_NAME);
            isJBTAnnotation = attribute != null;
        }
        return isJBTAnnotation;
    }

    private List<ICompletionProposal> getMarkerProposals(SimpleMarkerAnnotation annotation, Position position) {
        TextInvocationContext sseContext;
        ICompletionProposal[] compoundQuickAssistProcessorProposals;
        IMarkerResolution[] resolutions;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean isJBTAnnotation = MarkerAnnotationInfo.isJBTAnnotation((Annotation)annotation);
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] iMarkerResolutionArray = resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution resolution = iMarkerResolutionArray[n2];
            proposals.add(new QuickFixProposal(resolution, marker));
            ++n2;
        }
        if (!isJBTAnnotation && (compoundQuickAssistProcessorProposals = this.fCompoundQuickAssistProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)(sseContext = new TextInvocationContext(this.viewer, position.getOffset(), position.getLength())))) != null) {
            ICompletionProposal[] iCompletionProposalArray = compoundQuickAssistProcessorProposals;
            int n3 = compoundQuickAssistProcessorProposals.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompletionProposal proposal = iCompletionProposalArray[n4];
                proposals.add(proposal);
                ++n4;
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> getProposals(TemporaryAnnotation annotation, Position position) {
        ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
        ArrayList<IQuickAssistProcessor> processors = new ArrayList<IQuickAssistProcessor>();
        boolean isJBTAnnotation = MarkerAnnotationInfo.isJBTAnnotation((Annotation)annotation);
        if (QuickFixManager.getInstance().hasProposals((Annotation)annotation, position)) {
            if (annotation.getText().startsWith(UNKNOWN_TAG) || annotation.getText().startsWith(MISSING_ATTRIBUTE)) {
                annotation.setAdditionalFixInfo((Object)this.viewer.getDocument());
            }
            List<IJavaCompletionProposal> proposals = QuickFixManager.getInstance().getProposals((Annotation)annotation, position);
            allProposals.addAll(proposals);
        }
        if (!isJBTAnnotation) {
            Object o = annotation.getAdditionalFixInfo();
            if (o instanceof IQuickAssistProcessor) {
                processors.add((IQuickAssistProcessor)o);
            }
            QuickFixRegistry registry = QuickFixRegistry.getInstance();
            processors.addAll(Arrays.asList(registry.getQuickFixProcessors((Annotation)annotation)));
            Map attributes = annotation.getAttributes();
            StructuredTextInvocationContext sseContext = new StructuredTextInvocationContext(this.viewer, position.getOffset(), position.getLength(), attributes);
            ICompletionProposal[] compoundQuickAssistProcessorProposals = this.fCompoundQuickAssistProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)sseContext);
            if (compoundQuickAssistProcessorProposals != null) {
                ICompletionProposal[] iCompletionProposalArray = compoundQuickAssistProcessorProposals;
                int n = compoundQuickAssistProcessorProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal proposal = iCompletionProposalArray[n2];
                    allProposals.add(proposal);
                    ++n2;
                }
            }
            int i = 0;
            while (i < processors.size()) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                this.collectProposals((IQuickAssistProcessor)processors.get(i), (Annotation)annotation, (IQuickAssistInvocationContext)sseContext, proposals);
                allProposals.addAll(proposals);
                ++i;
            }
        }
        return allProposals;
    }

    private void collectProposals(IQuickAssistProcessor processor, Annotation annotation, IQuickAssistInvocationContext invocationContext, List<ICompletionProposal> proposalsList) {
        ICompletionProposal[] proposals = processor.computeQuickAssistProposals(invocationContext);
        if (proposals != null && proposals.length > 0) {
            proposalsList.addAll(Arrays.asList(proposals));
        }
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public String toString() {
        return null;
    }

    public static class AnnotationInfo {
        private ArrayList<Annotation> annotations = new ArrayList();
        private Position position;

        public AnnotationInfo(Annotation annotation, Position position) {
            this.add(annotation);
            this.position = position;
        }

        public void add(Annotation annotation) {
            this.annotations.add(annotation);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Annotation getMainAnnotation() {
            for (Annotation annotation : this.annotations) {
                if (!(annotation instanceof SimpleMarkerAnnotation)) continue;
                return annotation;
            }
            return this.annotations.get(0);
        }

        public Position getPosition() {
            return this.position;
        }

        public boolean isTop() {
            return MarkerAnnotationInfo.isJBTAnnotation(this.getMainAnnotation());
        }
    }
}

