/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jboss.ide.eclipse.freemarker.outline.OutlineContentProvider;

public class Preferences {
    private static final Preferences INSTANCE = new Preferences();
    private IPreferencesService preferencesService;
    private Map<String, Color> colorCache = new HashMap<String, Color>(16);

    public static Preferences getInstance() {
        return INSTANCE;
    }

    private Preferences() {
        this.preferencesService = Platform.getPreferencesService();
    }

    public String getString(PreferenceKey key) {
        return this.preferencesService.getString("org.jboss.ide.eclipse.freemarker", key.toString(), (String)key.getDefaultValue(), null);
    }

    public boolean getBoolean(PreferenceKey key) {
        return this.preferencesService.getBoolean("org.jboss.ide.eclipse.freemarker", key.toString(), ((Boolean)key.getDefaultValue()).booleanValue(), null);
    }

    public Color getColor(PreferenceKey preferenceKey) {
        String stringColor = this.getString(preferenceKey);
        Color color = this.colorCache.get(stringColor);
        if (color == null) {
            RGB rgb = StringConverter.asRGB((String)stringColor);
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorCache.put(stringColor, color);
        }
        return color;
    }

    public void dispose() {
        for (Color color : this.colorCache.values()) {
            color.dispose();
        }
        this.colorCache = null;
        this.preferencesService = null;
    }

    public static enum PreferenceKey {
        COLOR_DIRECTIVE("color.directive", "0,0,255"),
        COLOR_INTERPOLATION("color.interpolation", "255,0,128"),
        COLOR_COMMENT("color.comment", "170,0,0"),
        COLOR_TEXT("color.text", "0,0,0"),
        COLOR_STRING("color.string", "0,128,128"),
        COLOR_XML_TAG("color.xmlTag", "0,0,128"),
        COLOR_XML_COMMENT("color.xmlComment", "128,128,128"),
        COLOR_RELATED_ITEM("color.oppositeRegion", "255,255,128"),
        HIGHLIGHT_RELATED_ITEMS("boolean.highlightRelatedItems", Boolean.TRUE),
        OUTLINE_LEVEL_OF_DETAIL("outline.level.of.detail", OutlineContentProvider.OutlineLevelOfDetail.functionAndMacroDefinitions.name());

        private final String key;
        private final Object defaultValue;

        private PreferenceKey(String value, Object defaultValue) {
            this.key = value;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.key;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

