/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.outline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;

public class OutlineContentProvider
implements ITreeContentProvider {
    private boolean fullAstShown;
    private Editor fEditor;

    public OutlineContentProvider(Editor anEditor) {
        this.fEditor = anEditor;
        String level = Preferences.getInstance().getString(Preferences.PreferenceKey.OUTLINE_LEVEL_OF_DETAIL);
        try {
            this.fullAstShown = level != null && OutlineLevelOfDetail.valueOf(level) == OutlineLevelOfDetail.full;
        }
        catch (IllegalArgumentException e) {
            Plugin.log(e);
            this.fullAstShown = false;
        }
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
    }

    public boolean isDeleted(Object anElement) {
        return false;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (this.fullAstShown) {
            Collection<Item> items = this.fEditor.getItemSet().getDirectiveRegions().values();
            ArrayList<Item> result = new ArrayList<Item>(items.size());
            for (Item item : items) {
                if (item.getParentItem() != null || item.isEndItem()) continue;
                result.add(item);
            }
            return result.toArray();
        }
        List<Item> outlineItems = this.fEditor.getItemSet().getOutlineItems();
        return outlineItems.toArray();
    }

    public Object[] getChildren(Object anElement) {
        if (this.fullAstShown && anElement instanceof Item) {
            if (anElement instanceof MacroDirective) {
                return null;
            }
            List<Item> children = ((Item)anElement).getChildItems();
            ArrayList<Item> result = new ArrayList<Item>(children.size());
            for (Item item : children) {
                if (item.isEndItem()) continue;
                result.add(item);
            }
            return result.toArray();
        }
        return null;
    }

    public Object getParent(Object anElement) {
        if (anElement instanceof Item) {
            return ((Item)anElement).getParentItem();
        }
        return null;
    }

    public boolean hasChildren(Object anElement) {
        if (this.fullAstShown && anElement instanceof Item) {
            Item item = (Item)anElement;
            return !item.getChildItems().isEmpty();
        }
        return false;
    }

    public static enum OutlineLevelOfDetail {
        functionAndMacroDefinitions,
        full;


        public static OutlineLevelOfDetail getDefault() {
            return functionAndMacroDefinitions;
        }
    }
}

