/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.lang.Directive;
import org.jboss.ide.eclipse.freemarker.model.Interpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.MacroEndInstance;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class ItemFactory {
    public static Item getItem(ItemSet itemSet, ITypedRegion region, ISourceViewer viewer, IResource resource) {
        if (region == null) {
            return null;
        }
        Item directive = null;
        String type = region.getType();
        Directive directiveType = Directive.fastValueOf(type);
        if (directiveType != null) {
            directive = directiveType.createModelItem(itemSet);
        } else {
            PartitionType partitionType = PartitionType.fastValueOf(type);
            switch (partitionType) {
                case DOLLAR_INTERPOLATION: 
                case HASH_INTERPOLATION: {
                    directive = new Interpolation(itemSet);
                    break;
                }
                case MACRO_INSTANCE_START: {
                    directive = new MacroInstance(itemSet);
                    break;
                }
                case MACRO_INSTANCE_END: {
                    directive = new MacroEndInstance(itemSet);
                    break;
                }
            }
        }
        if (directive != null) {
            directive.load(region, viewer, resource);
        }
        return directive;
    }
}

