/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableEndDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;

public class GenericNestableDirective
extends AbstractDirective {
    private String image;
    private String name;
    private GenericNestableEndDirective endDirective;
    private Item[] relatedItems;

    public GenericNestableDirective(ItemSet itemSet, String name, String image) {
        super(itemSet);
        this.name = name;
        this.image = image;
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) {
    }

    @Override
    public String getTreeImage() {
        return this.image;
    }

    @Override
    public Item getStartItem() {
        return this;
    }

    @Override
    public boolean isNestable() {
        return !this.getContents().trim().endsWith("/");
    }

    @Override
    public boolean isStartItem() {
        return true;
    }

    @Override
    public boolean relatesToItem(Item directive) {
        if (directive instanceof GenericNestableEndDirective) {
            return ((GenericNestableEndDirective)directive).getName().equals(this.name);
        }
        return false;
    }

    @Override
    public void relateItem(Item directive) {
        if (directive instanceof GenericNestableEndDirective) {
            this.endDirective = (GenericNestableEndDirective)directive;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Item getEndItem() {
        return this.endDirective;
    }

    @Override
    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            this.relatedItems = this.endDirective != null ? new Item[]{this.endDirective} : new Item[0];
        }
        return this.relatedItems;
    }
}

