/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.lang.Directive;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AssignmentEndDirective;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;

public class AssignmentDirective
extends AbstractDirective {
    private AssignmentEndDirective endDirective;
    private Directive type;
    private Boolean nestable = null;
    private Item[] relatedItems;
    Map<String, Class<?>> contextValues;

    public static Boolean isNestable(String cont, Directive type) throws ParserUtils.ParseException {
        ParserUtils parser = new ParserUtils(cont);
        parser.match(type.getKeyword().toString());
        parser.consumeWhiteSpace();
        parser.consumeIdentifierOrStringLiteral();
        parser.consumeWhiteSpace();
        return parser.isAtEndOfInput() || !parser.matches('=', false);
    }

    public AssignmentDirective(ItemSet itemSet, Directive type) {
        super(itemSet);
        this.type = type;
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) {
    }

    @Override
    public boolean isStartItem() {
        return super.isNestable();
    }

    @Override
    public void relateItem(Item directive) {
        if (directive instanceof AssignmentEndDirective) {
            this.endDirective = (AssignmentEndDirective)directive;
        }
    }

    @Override
    public boolean relatesToItem(Item directive) {
        return directive instanceof AssignmentEndDirective;
    }

    @Override
    public boolean isNestable() {
        if (this.nestable == null) {
            try {
                this.nestable = AssignmentDirective.isNestable(this.getContents(), this.type);
            }
            catch (ParserUtils.ParseException e) {
                Plugin.log(e);
                this.nestable = Boolean.FALSE;
            }
        }
        return this.nestable;
    }

    public AssignmentEndDirective getEndDirective() {
        return this.endDirective;
    }

    @Override
    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<AssignmentEndDirective> l = new ArrayList<AssignmentEndDirective>();
            if (this.endDirective != null) {
                l.add(this.endDirective);
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    @Override
    public String getTreeImage() {
        return "assign.png";
    }

    @Override
    public void addToContext(Map<String, Class<?>> context) {
        if (this.contextValues == null) {
            String[] values = this.splitContents();
            String key = null;
            String value = null;
            if (values.length >= 2) {
                key = values[1];
            }
            if (values.length >= 4) {
                value = values[3];
            }
            Class valueClass = null;
            if (value != null && value.length() > 0) {
                if (value.charAt(0) == '\"') {
                    valueClass = String.class;
                } else if (Character.isDigit(value.charAt(0))) {
                    valueClass = Number.class;
                } else {
                    CompletionInterpolation completionInterpolation = new CompletionInterpolation(this.getItemSet(), "${" + value, 2, this.getResource());
                    valueClass = completionInterpolation.getReturnClass(context);
                }
            }
            if (key != null) {
                context.put(key, valueClass);
            }
        }
        super.addToContext(context);
    }

    @Override
    public Item getEndItem() {
        return this.endDirective;
    }
}

