/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ide.eclipse.freemarker.lang.Keyword;
import org.jboss.ide.eclipse.freemarker.model.AssignmentDirective;
import org.jboss.ide.eclipse.freemarker.model.AssignmentEndDirective;
import org.jboss.ide.eclipse.freemarker.model.CaseDefaultDirective;
import org.jboss.ide.eclipse.freemarker.model.CaseDirective;
import org.jboss.ide.eclipse.freemarker.model.ElseIfDirective;
import org.jboss.ide.eclipse.freemarker.model.FtlDirective;
import org.jboss.ide.eclipse.freemarker.model.FunctionDirective;
import org.jboss.ide.eclipse.freemarker.model.FunctionEndDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableEndDirective;
import org.jboss.ide.eclipse.freemarker.model.IfDirective;
import org.jboss.ide.eclipse.freemarker.model.IfElseDirective;
import org.jboss.ide.eclipse.freemarker.model.IfEndDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.ListDirective;
import org.jboss.ide.eclipse.freemarker.model.ListEndDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroEndDirective;

public abstract class Directive
extends Enum<Directive> {
    public static final /* enum */ Directive INCLUDE;
    public static final /* enum */ Directive IMPORT;
    public static final /* enum */ Directive ASSIGN;
    public static final /* enum */ Directive ASSIGN_END;
    public static final /* enum */ Directive LOCAL;
    public static final /* enum */ Directive LOCAL_END;
    public static final /* enum */ Directive GLOBAL;
    public static final /* enum */ Directive GLOBAL_END;
    public static final /* enum */ Directive BREAK;
    public static final /* enum */ Directive NESTED;
    public static final /* enum */ Directive RETURN;
    public static final /* enum */ Directive STOP;
    public static final /* enum */ Directive LIST;
    public static final /* enum */ Directive LIST_END;
    public static final /* enum */ Directive IF;
    public static final /* enum */ Directive ELSEIF;
    public static final /* enum */ Directive ELSE;
    public static final /* enum */ Directive IF_END;
    public static final /* enum */ Directive SWITCH;
    public static final /* enum */ Directive SWITCH_END;
    public static final /* enum */ Directive CASE;
    public static final /* enum */ Directive DEFAULT;
    public static final /* enum */ Directive MACRO;
    public static final /* enum */ Directive MACRO_END;
    public static final /* enum */ Directive FTL;
    public static final /* enum */ Directive FUNCTION;
    public static final /* enum */ Directive FUNCTION_END;
    private static final Map<String, Directive> FAST_LOOKUP;
    protected final Keyword keyword;
    private static final /* synthetic */ Directive[] ENUM$VALUES;

    static {
        Directive[] directives;
        INCLUDE = new Directive(Keyword.INCLUDE){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "include.png");
            }
        };
        IMPORT = new Directive(Keyword.IMPORT){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "import.png");
            }
        };
        ASSIGN = new Directive(Keyword.ASSIGN){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentDirective(itemSet, this);
            }
        };
        ASSIGN_END = new Directive(Keyword.ASSIGN){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentEndDirective(itemSet, this.name());
            }
        };
        LOCAL = new Directive(Keyword.LOCAL){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentDirective(itemSet, this);
            }
        };
        LOCAL_END = new Directive(Keyword.LOCAL){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentEndDirective(itemSet, this.name());
            }
        };
        GLOBAL = new Directive(Keyword.GLOBAL){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentDirective(itemSet, this);
            }
        };
        GLOBAL_END = new Directive(Keyword.GLOBAL){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new AssignmentEndDirective(itemSet, this.name());
            }
        };
        BREAK = new Directive(Keyword.BREAK){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "break.png");
            }
        };
        NESTED = new Directive(Keyword.NESTED){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "nested.png");
            }
        };
        RETURN = new Directive(Keyword.RETURN){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "return.png");
            }
        };
        STOP = new Directive(Keyword.STOP){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericDirective(itemSet, "stop.png");
            }
        };
        LIST = new Directive(Keyword.LIST){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new ListDirective(itemSet);
            }
        };
        LIST_END = new Directive(Keyword.LIST){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new ListEndDirective(itemSet);
            }
        };
        IF = new Directive(Keyword.IF){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new IfDirective(itemSet);
            }
        };
        ELSEIF = new Directive(Keyword.ELSE_IF){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new ElseIfDirective(itemSet);
            }
        };
        ELSE = new Directive(Keyword.ELSE){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new IfElseDirective(itemSet);
            }
        };
        IF_END = new Directive(Keyword.IF){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new IfEndDirective(itemSet);
            }
        };
        SWITCH = new Directive(Keyword.SWITCH){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericNestableDirective(itemSet, this.keyword.name().toLowerCase(), "switch.png");
            }
        };
        SWITCH_END = new Directive(Keyword.SWITCH){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new GenericNestableEndDirective(itemSet, this.keyword.name().toLowerCase());
            }
        };
        CASE = new Directive(Keyword.CASE){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new CaseDirective(itemSet);
            }
        };
        DEFAULT = new Directive(Keyword.DEFAULT){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new CaseDefaultDirective(itemSet);
            }
        };
        MACRO = new Directive(Keyword.MACRO){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new MacroDirective(itemSet);
            }
        };
        MACRO_END = new Directive(Keyword.MACRO){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new MacroEndDirective(itemSet);
            }
        };
        FTL = new Directive(Keyword.FTL){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new FtlDirective(itemSet);
            }
        };
        FUNCTION = new Directive(Keyword.FUNCTION){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new FunctionDirective(itemSet);
            }
        };
        FUNCTION_END = new Directive(Keyword.FUNCTION){

            @Override
            public Item createModelItem(ItemSet itemSet) {
                return new FunctionEndDirective(itemSet);
            }
        };
        ENUM$VALUES = new Directive[]{INCLUDE, IMPORT, ASSIGN, ASSIGN_END, LOCAL, LOCAL_END, GLOBAL, GLOBAL_END, BREAK, NESTED, RETURN, STOP, LIST, LIST_END, IF, ELSEIF, ELSE, IF_END, SWITCH, SWITCH_END, CASE, DEFAULT, MACRO, MACRO_END, FTL, FUNCTION, FUNCTION_END};
        HashMap<String, Directive> fastLookUp = new HashMap<String, Directive>(64);
        Directive[] directiveArray = directives = Directive.values();
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            Directive directive = directiveArray[n2];
            fastLookUp.put(directive.name(), directive);
            ++n2;
        }
        FAST_LOOKUP = Collections.unmodifiableMap(fastLookUp);
    }

    public static Directive fastValueOf(String str) {
        return FAST_LOOKUP.get(str);
    }

    private Directive(Keyword keyword) {
        this.keyword = keyword;
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public abstract Item createModelItem(ItemSet var1);

    public static Directive[] values() {
        Directive[] directiveArray = ENUM$VALUES;
        int n = directiveArray.length;
        Directive[] directiveArray2 = new Directive[n];
        System.arraycopy(ENUM$VALUES, 0, directiveArray2, 0, n);
        return directiveArray2;
    }

    public static Directive valueOf(String string) {
        return Enum.valueOf(Directive.class, string);
    }

    /* synthetic */ Directive(String string, int n, Keyword keyword, Directive directive) {
        this(keyword);
    }
}

