/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.rules;

import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.SyntaxModeListener;
import org.jboss.ide.eclipse.freemarker.lang.Directive;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.lang.SyntaxMode;

public class DirectiveRule
extends MultiLineRule
implements SyntaxModeListener {
    protected final String name;
    protected final boolean nameOnly;
    protected final char identifierChar;
    protected SyntaxMode syntaxMode = SyntaxMode.getDefault();

    public DirectiveRule(Directive directive) {
        this(directive, false);
    }

    public DirectiveRule(Directive directive, boolean nameOnly) {
        this(directive, nameOnly, '#');
    }

    public DirectiveRule(Directive directive, boolean nameOnly, char identifierChar) {
        this(directive.getKeyword().toString(), directive.name(), nameOnly, identifierChar);
    }

    public DirectiveRule(String name, String tokenData, boolean nameOnly, char identifierChar) {
        super("!", "!", (IToken)new Token((Object)tokenData));
        this.name = name;
        this.nameOnly = nameOnly;
        this.identifierChar = identifierChar;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, int startChar, boolean eofAllowed) {
        int i = 0;
        while (i < this.name.length()) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != this.name.charAt(i)) {
                scanner.unread();
                int j = i;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner, int startChar) {
        int c;
        char endChar = ParserUtils.getMatchingRightBracket(startChar);
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        Stack<Character> keyStack = new Stack<Character>();
        int charsRead = 0;
        while ((c = scanner.read()) != -1) {
            ++charsRead;
            char cCheck = (char)c;
            if (this.nameOnly) {
                if (c != endChar) {
                    scanner.unread();
                    return false;
                }
                return true;
            }
            if (c == startChar) {
                int cNext = scanner.read();
                if (cNext == -1) break;
                if (cNext == 35 || cNext == 64) {
                    if (keyStack.size() == 0) {
                        break;
                    }
                } else {
                    keyStack.push(Character.valueOf(cCheck));
                    scanner.unread();
                }
            } else if (c == 34) {
                if (keyStack.size() > 0 && ((Character)keyStack.peek()).charValue() == '\"') {
                    keyStack.pop();
                } else {
                    keyStack.push(Character.valueOf(cCheck));
                }
            } else if (c == 40) {
                if (keyStack.size() <= 0 || ((Character)keyStack.peek()).charValue() != '\"') {
                    keyStack.push(Character.valueOf(cCheck));
                }
            } else if (c == 41) {
                if ((keyStack.size() <= 0 || ((Character)keyStack.peek()).charValue() != '\"') && keyStack.size() > 0 && ((Character)keyStack.peek()).charValue() == '(') {
                    keyStack.pop();
                }
            } else if (c == this.fEscapeCharacter) {
                scanner.read();
                ++charsRead;
            } else if (c == endChar) {
                if (keyStack.size() == 0) {
                    return true;
                }
                if (((Character)keyStack.peek()).charValue() == startChar) {
                    keyStack.pop();
                }
            } else if (this.fBreaksOnEOL) {
                int i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        int i = 0;
        while (i < charsRead) {
            scanner.unread();
            ++i;
        }
        return false;
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == this.syntaxMode.getStart()) {
                int c2 = scanner.read();
                if (c2 == this.identifierChar && this.sequenceDetected(scanner, c, false) && this.endSequenceDetected(scanner, c)) {
                    return this.fToken;
                }
                scanner.unread();
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    @Override
    public void syntaxModeChanged(SyntaxMode syntaxMode) {
        this.syntaxMode = syntaxMode;
    }
}

