/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.jboss.ide.eclipse.freemarker.Messages;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.dialogs.ContextValueDialog;
import org.jboss.ide.eclipse.freemarker.editor.Editor;

public class FreemarkerMultiPageEditor
extends MultiPageEditorPart
implements ITextEditor,
ITextEditorExtension {
    public static final String ID = "org.jboss.ide.eclipse.freemarker.editor.FreemarkerEditor";
    private Editor vEditor;
    private boolean readOnly = false;
    static String currentProject;
    private Table contextValuesTable;
    private Button editContextValueButton;
    private Button deleteContextValueButton;
    private Button addContextValueButton;

    protected void createPages() {
        this.createPage0();
        if (!this.vEditor.isEditorInputReadOnly()) {
            this.createContextPage();
        }
    }

    void createPage0() {
        try {
            this.vEditor = new Editor();
            if (this.readOnly) {
                this.vEditor.setReadOnly(this.readOnly);
            }
            int index = this.addPage((IEditorPart)this.vEditor, this.getEditorInput());
            this.setPageText(index, Messages.FreemarkerMultiPageEditor_PAGE_TEXT_SOURCE);
            this.setPartName(this.vEditor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.FreemarkerMultiPageEditor_ERROR_CREATING_VEDITOR, null, (IStatus)e.getStatus());
        }
    }

    public Editor getEditor() {
        return this.vEditor;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.reloadContextValues();
        }
    }

    void createContextPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        this.contextValuesTable = new Table(composite, 67840);
        this.contextValuesTable.setVisible(true);
        this.contextValuesTable.setLinesVisible(false);
        this.contextValuesTable.setHeaderVisible(true);
        this.contextValuesTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FreemarkerMultiPageEditor.this.editContextValueButton.setEnabled(true);
                FreemarkerMultiPageEditor.this.deleteContextValueButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.contextValuesTable.addKeyListener((KeyListener)new ContextValueDeleteKeyListener());
        this.contextValuesTable.addMouseListener((MouseListener)new EditContextValueButtonListener());
        TableColumn keyColumn = new TableColumn(this.contextValuesTable, 16384);
        TableColumn valueColumn = new TableColumn(this.contextValuesTable, 16384);
        keyColumn.setText(Messages.FreemarkerMultiPageEditor_COLUMN_NAME);
        valueColumn.setText(Messages.FreemarkerMultiPageEditor_COLUMN_TYPE);
        ColumnWeightData keyColumnLayout = new ColumnWeightData(30, false);
        ColumnWeightData valueColumnLayout = new ColumnWeightData(70, false);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)keyColumnLayout);
        tableLayout.addColumnData((ColumnLayoutData)valueColumnLayout);
        this.contextValuesTable.setLayout((Layout)tableLayout);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.contextValuesTable.setLayoutData((Object)data);
        Composite buttonComposite = new Composite(composite, 0);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setVisible(true);
        this.addContextValueButton = new Button(buttonComposite, 8);
        this.addContextValueButton.setText(Messages.FreemarkerMultiPageEditor_BUTTON_NEW);
        this.addContextValueButton.setVisible(true);
        this.addContextValueButton.setLayoutData((Object)new GridData(512));
        this.addContextValueButton.addSelectionListener((SelectionListener)new AddContextValueButtonListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.addContextValueButton.setLayoutData((Object)data);
        this.editContextValueButton = new Button(buttonComposite, 8);
        this.editContextValueButton.setText(Messages.FreemarkerMultiPageEditor_BUTTON_EDIT);
        this.editContextValueButton.setLayoutData((Object)new GridData(512));
        this.editContextValueButton.addSelectionListener((SelectionListener)new EditContextValueButtonListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.editContextValueButton.setLayoutData((Object)data);
        this.deleteContextValueButton = new Button(buttonComposite, 8);
        this.deleteContextValueButton.setText(Messages.FreemarkerMultiPageEditor_BUTTON_DELETE);
        this.deleteContextValueButton.setLayoutData((Object)new GridData(512));
        this.deleteContextValueButton.addSelectionListener((SelectionListener)new ContextValueDeleteKeyListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.deleteContextValueButton.setLayoutData((Object)data);
        this.reloadContextValues();
        int index = this.addPage((Control)composite);
        this.setPageText(index, Messages.FreemarkerMultiPageEditor_PAGE_TEXT_CONTEXT);
    }

    public void reloadContextValues() {
        try {
            this.contextValuesTable.removeAll();
            ContextValue[] values = ConfigurationManager.getInstance(this.vEditor.getFile().getProject()).getContextValues((IResource)this.vEditor.getFile(), false);
            int i = 0;
            while (i < values.length) {
                TableItem item = new TableItem(this.contextValuesTable, 0);
                String[] arr = new String[]{values[i].name, values[i].objClass.getName()};
                item.setText(arr);
                ++i;
            }
            this.editContextValueButton.setEnabled(false);
            this.deleteContextValueButton.setEnabled(false);
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        this.contextValuesTable.redraw();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        if (!(editorInput instanceof IFileEditorInput)) {
            this.readOnly = true;
            if (this.vEditor != null) {
                this.vEditor.setReadOnly(true);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public Object getAdapter(Class aClass) {
        return this.vEditor.getAdapter(aClass);
    }

    public void close(boolean save) {
        this.vEditor.close(save);
    }

    public void doRevertToSaved() {
        this.vEditor.doRevertToSaved();
    }

    public IAction getAction(String actionId) {
        return this.vEditor.getAction(actionId);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.vEditor.getDocumentProvider();
    }

    public IRegion getHighlightRange() {
        return this.vEditor.getHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.vEditor.getSelectionProvider();
    }

    public boolean isEditable() {
        return this.vEditor.isEditable();
    }

    public void removeActionActivationCode(String actionId) {
        this.vEditor.removeActionActivationCode(actionId);
    }

    public void resetHighlightRange() {
        this.vEditor.resetHighlightRange();
    }

    public void selectAndReveal(int offset, int length) {
        this.vEditor.selectAndReveal(offset, length);
    }

    public void setAction(String actionID, IAction action) {
        this.vEditor.setAction(actionID, action);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this.vEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this.vEditor.setHighlightRange(offset, length, moveCursor);
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.vEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public boolean showsHighlightRangeOnly() {
        return this.vEditor.showsHighlightRangeOnly();
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        this.vEditor.addRulerContextMenuListener(listener);
    }

    public boolean isEditorInputReadOnly() {
        return this.vEditor.isEditorInputReadOnly();
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        this.vEditor.removeRulerContextMenuListener(listener);
    }

    public void setStatusField(IStatusField field, String category) {
        this.vEditor.setStatusField(field, category);
    }

    public class AddContextValueButtonListener
    implements SelectionListener {
        public void mouseDoubleClick(MouseEvent e) {
            this.doWork();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doWork() {
            ContextValueDialog dialog = new ContextValueDialog(new Shell(), null, (IResource)FreemarkerMultiPageEditor.this.vEditor.getFile());
            if (dialog.open() == 0) {
                FreemarkerMultiPageEditor.this.reloadContextValues();
            }
        }
    }

    public class ContextValueDeleteKeyListener
    implements SelectionListener,
    KeyListener {
        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127) {
                this.doWork();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void doWork() {
            int index = FreemarkerMultiPageEditor.this.contextValuesTable.getSelectionIndex();
            if (index >= 0) {
                try {
                    boolean confirm = MessageDialog.openConfirm((Shell)new Shell(), (String)Messages.FreemarkerMultiPageEditor_CONFIRMATION_TITLE, (String)Messages.FreemarkerMultiPageEditor_CONFIRMATION_TO_DELETE_MESSAGE);
                    if (confirm) {
                        String key = FreemarkerMultiPageEditor.this.contextValuesTable.getSelection()[0].getText(0);
                        ContextValue value = ConfigurationManager.getInstance(FreemarkerMultiPageEditor.this.vEditor.getFile().getProject()).getContextValue(key, (IResource)FreemarkerMultiPageEditor.this.vEditor.getFile(), false);
                        ConfigurationManager.getInstance(FreemarkerMultiPageEditor.this.vEditor.getFile().getProject()).removeContextValue(value.name, (IResource)FreemarkerMultiPageEditor.this.vEditor.getFile());
                        FreemarkerMultiPageEditor.this.reloadContextValues();
                    }
                }
                catch (Exception e1) {
                    Plugin.error(e1);
                }
            }
        }
    }

    public class EditContextValueButtonListener
    implements SelectionListener,
    MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            this.doWork();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doWork() {
            int index = FreemarkerMultiPageEditor.this.contextValuesTable.getSelectionIndex();
            if (index >= 0) {
                String key = FreemarkerMultiPageEditor.this.contextValuesTable.getSelection()[0].getText(0);
                ContextValue value = ConfigurationManager.getInstance(FreemarkerMultiPageEditor.this.vEditor.getFile().getProject()).getContextValue(key, (IResource)FreemarkerMultiPageEditor.this.vEditor.getFile(), false);
                ContextValueDialog dialog = new ContextValueDialog(new Shell(), value, (IResource)FreemarkerMultiPageEditor.this.vEditor.getFile());
                if (dialog.open() == 0) {
                    FreemarkerMultiPageEditor.this.reloadContextValues();
                }
            }
        }
    }
}

