/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.configuration;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.ide.eclipse.freemarker.Plugin;

public class ProjectClassLoader
extends URLClassLoader {
    public ProjectClassLoader(IJavaProject project) throws JavaModelException {
        super(ProjectClassLoader.getURLSFromProject(project, null), Thread.currentThread().getContextClassLoader());
    }

    public ProjectClassLoader(IJavaProject project, URL[] extraUrls) throws JavaModelException {
        super(ProjectClassLoader.getURLSFromProject(project, extraUrls), Thread.currentThread().getContextClassLoader());
    }

    private static URL[] getURLSFromProject(IJavaProject project, URL[] extraUrls) throws JavaModelException {
        ArrayList<URL> list = new ArrayList<URL>();
        if (extraUrls != null) {
            int i = 0;
            while (i < extraUrls.length) {
                list.add(extraUrls[i]);
                ++i;
            }
        }
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        String installLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath();
        if ((installLoc = installLoc.replace('\\', '/')).endsWith("/")) {
            installLoc = installLoc.substring(0, installLoc.length() - 1);
        }
        int i = 0;
        while (i < roots.length) {
            try {
                if (roots[i].isArchive()) {
                    File f = new File(FileLocator.resolve((URL)roots[i].getPath().makeAbsolute().toFile().toURI().toURL()).getFile());
                    if (f.exists()) {
                        list.add(FileLocator.resolve((URL)roots[i].getPath().makeAbsolute().toFile().toURI().toURL()));
                    } else {
                        String s = roots[i].getPath().toOSString().replace('\\', '/');
                        if (!s.startsWith("/")) {
                            s = "/" + s;
                        }
                        if ((f = new File(String.valueOf(installLoc) + s)).exists()) {
                            list.add(f.toURI().toURL());
                        } else {
                            f = new File("c:" + installLoc + s);
                            if (f.exists()) {
                                list.add(f.toURI().toURL());
                            } else {
                                f = new File("d:" + installLoc + s);
                                if (f.exists()) {
                                    list.add(f.toURI().toURL());
                                }
                            }
                        }
                    }
                } else {
                    IPath path = roots[i].getJavaProject().getOutputLocation();
                    if (path.segmentCount() > 1) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        path = root.getFolder(path).getLocation();
                        list.add(path.toFile().toURI().toURL());
                    } else {
                        path = roots[i].getJavaProject().getProject().getLocation();
                        list.add(path.toFile().toURI().toURL());
                    }
                }
            }
            catch (Exception e) {
                Plugin.log(e);
            }
            ++i;
        }
        return list.toArray(new URL[list.size()]);
    }
}

