/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import com.github.zafarkhaja.semver.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.ios.core.IOSCore;

public class IosLibraryResolver
extends HybridMobileLibraryResolver {
    private static final Version VERSION_3_3_0 = Version.valueOf((String)"3.3.0");
    private static final Version VERSION_3_0_0 = Version.valueOf((String)"3.0.0");
    private static final String TEMPLATEVAR_PRJ_DIR_3_0 = "__TESTING__";
    private static final String TEMPLATEVAR_PRJ_DIR_3_4 = "__PROJECT_NAME__";
    private static final String TEMPLATEVAR_PBXPROJ_3_0 = "__TESTING__";
    private static final String TEMPLATEVAR_PBXPROJ_3_4 = "__NON-CLI__";
    private HashMap<IPath, URL> files = new HashMap();

    private void initFiles() {
        IPath templatePrjRoot = this.libraryRoot.append("bin/templates/project");
        if (this.version == null) {
            return;
        }
        Version v = Version.valueOf((String)this.version);
        String prjDirVar = "__TESTING__";
        String pbxProjVar = "__TESTING__";
        if (v.compareWithBuildsTo(VERSION_3_3_0) > 0) {
            prjDirVar = TEMPLATEVAR_PRJ_DIR_3_4;
            pbxProjVar = TEMPLATEVAR_PBXPROJ_3_4;
        }
        if (v.equals((Object)VERSION_3_0_0)) {
            this.files.put((IPath)new Path("cordova"), this.getEngineFile(this.libraryRoot.append("bin/templates/project/cordova/")));
        } else {
            this.files.put((IPath)new Path("cordova"), this.getEngineFile(this.libraryRoot.append("bin/templates/scripts/cordova/")));
        }
        this.files.put((IPath)new Path("$appname"), this.getEngineFile(templatePrjRoot.append(prjDirVar)));
        this.files.put((IPath)new Path("$appname/$appname-Info.plist"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/{0}-Info.plist", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname/$appname-Prefix.pch"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/{0}-Prefix.pch", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname.xcodeproj/project.pbxproj"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}.xcodeproj/project.pbxproj", (Object)pbxProjVar))));
        this.files.put((IPath)new Path("$appname/Classes/AppDelegate.h"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/Classes/AppDelegate.h", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname/Classes/AppDelegate.m"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/Classes/AppDelegate.m", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname/Classes/MainViewController.h"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/Classes/MainViewController.h", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname/Classes/MainViewController.m"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/Classes/MainViewController.m", (Object)prjDirVar))));
        this.files.put((IPath)new Path("$appname/main.m"), this.getEngineFile(templatePrjRoot.append(NLS.bind((String)"{0}/main.m", (Object)prjDirVar))));
        this.files.put((IPath)new Path("CordovaLib"), this.getEngineFile(this.libraryRoot.append("CordovaLib")));
        this.files.put(PATH_CORDOVA_JS, this.getEngineFile(this.libraryRoot.append("CordovaLib").append(PATH_CORDOVA_JS)));
    }

    public URL getTemplateFile(IPath destination) {
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        Assert.isNotNull((Object)destination);
        Assert.isTrue((!destination.isAbsolute() ? 1 : 0) != 0);
        return this.files.get(destination);
    }

    public IStatus isLibraryConsistent() {
        if (this.version == null) {
            return new Status(4, "org.eclipse.thym.core", "Library for iOS platform is not compatible with this tool. VERSION file is missing.");
        }
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        for (IPath key : this.files.keySet()) {
            File file;
            URL url = this.files.get(key);
            if (url != null && (file = new File(url.getFile())).exists()) continue;
            return new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Library for iOS platform is not compatible with this tool. File for path {0} is missing.", (Object)key.toString()));
        }
        return Status.OK_STATUS;
    }

    private URL getEngineFile(IPath path) {
        File file = path.toFile();
        if (!file.exists()) {
            HybridCore.log((int)4, (String)("missing iOS engine file " + file.toString()), null);
        }
        return FileUtils.toURL((File)file);
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
    }

    public boolean needsPreCompilation() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String detectVersion() {
        File versionFile = this.libraryRoot.append("CordovaLib").append("VERSION").toFile();
        if (!versionFile.exists()) {
            IOSCore.log(4, NLS.bind((String)"Can not detect version. VERSION file {0} is missing", (Object)versionFile.toString()), null);
            return null;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(versionFile));
                String version = reader.readLine();
                if (version == null) return null;
                String string = version.trim();
                return string;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            IOSCore.log(4, "Can not detect version on library", e);
            return null;
        }
    }
}

