/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aerogear.thym.internal.convert;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.jboss.tools.aerogear.thym.ThymPlugin;

public class NatureConvertListener
implements IResourceChangeListener,
IStartup {
    private static final String LEGACY_NATURE_ID = "org.jboss.tools.aerogear.hybrid.core.HybridAppNature";
    private static NatureConvertListener instance;

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta[] iResourceDeltaArray = projectDeltas = event.getDelta().getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (delta.getResource().getType() == 4) {
                this.checkNature(delta.getResource().getProject());
            }
            ++n2;
        }
    }

    private void checkNature(final IProject project) {
        try {
            if (project.isOpen() && project.hasNature(LEGACY_NATURE_ID) && !project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
                WorkspaceJob job = new WorkspaceJob("Convert to Thym nature"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        IProjectDescription desc = project.getDescription();
                        String[] natures = desc.getNatureIds();
                        int i = 0;
                        while (i < natures.length) {
                            if (natures[i].equals(NatureConvertListener.LEGACY_NATURE_ID)) {
                                natures[i] = "org.eclipse.thym.core.HybridAppNature";
                            }
                            ++i;
                        }
                        desc.setNatureIds(natures);
                        project.setDescription(desc, monitor);
                        ThymPlugin.log(2, "Converted obsolete \"org.jboss.tools.aerogear.hybrid.core.HybridAppNature\" nature to \"org.eclipse.thym.core.HybridAppNature\" for project \"" + project.getName() + "\"", null);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        catch (CoreException e) {
            ThymPlugin.log(2, "error while reading natures", e);
        }
    }

    public void earlyStartup() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.checkNature(project);
            ++n2;
        }
        instance = new NatureConvertListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)instance, 1);
    }

    public static final NatureConvertListener getInstance() {
        return instance;
    }
}

