/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.require;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.text.ext.util.xpl.RegistryReader;
import org.jboss.tools.jst.web.kb.require.KbRequireDefinition;

public class KbRequireBuilder
extends RegistryReader {
    public static final String PL_KB_REQUIRE = "KbRequire";
    public static final String TAG_REQUIRE = "require";
    public static final String ATT_ID = "id";
    public static final String ATT_FOR_NATURE = "forNature";
    public static final String ATT_DESCRIPTION = "description";
    private static KbRequireBuilder fInstance;
    protected String fTargetContributionElement;
    List<KbRequireDefinition> fDefinitions = null;

    public static synchronized KbRequireBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new KbRequireBuilder();
        }
        return fInstance;
    }

    private KbRequireBuilder() {
        this.readContributions(TAG_REQUIRE, PL_KB_REQUIRE);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_REQUIRE)) {
            this.processRequireElement(element);
        }
        return false;
    }

    private boolean processRequireElement(IConfigurationElement element) {
        String forNature = element.getAttribute(ATT_FOR_NATURE);
        String description = element.getAttribute(ATT_DESCRIPTION);
        if (forNature != null && forNature.trim().length() > 0) {
            if (this.fDefinitions == null) {
                this.fDefinitions = new ArrayList<KbRequireDefinition>();
            }
            this.fDefinitions.add(new KbRequireDefinition(forNature, description));
            return true;
        }
        return false;
    }

    protected void readContributions(String element, String extensionPoint) {
        this.fTargetContributionElement = element;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, "org.jboss.tools.jst.web.kb", extensionPoint);
    }

    public List<KbRequireDefinition> getKbRequireDefinitions() {
        return this.fDefinitions;
    }
}

