/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.AbstractClassPathMonitor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

public class ClassPathMonitor
extends AbstractClassPathMonitor<KbProject> {
    boolean isProcessed = false;

    public ClassPathMonitor(KbProject project) {
        this.project = project;
    }

    public void init() {
        this.model = InnerModelHelper.createXModel((IProject)((KbProject)this.project).getProject());
        super.init();
    }

    public IProject getProjectResource() {
        return ((KbProject)this.project).getProject();
    }

    public void process() {
        this.isProcessed = true;
        try {
            this.doProcess();
        }
        finally {
            this.isProcessed = false;
        }
    }

    protected void doProcess() {
        if (this.paths == null) {
            ModelPlugin.getDefault().logError("Failed to process class path in kb builder for project " + this.project);
            return;
        }
        for (String p : this.syncProcessedPaths()) {
            ((KbProject)this.project).pathRemoved((IPath)new Path(p));
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = (String)this.paths.get(i);
            if (this.requestForLoad(p)) {
                XModelObject o;
                LibraryScanner scanner = new LibraryScanner();
                String fileName = new File(p).getName();
                if (!EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName) && (o = FileSystemsHelper.getLibs((XModel)this.model).getLibrary(p)) != null) {
                    LoadedDeclarations c = null;
                    try {
                        if (scanner.isLikelyComponentSource(o)) {
                            c = scanner.parse(o, (IPath)new Path(p), (IKbProject)this.project);
                        }
                    }
                    catch (ScannerException e) {
                        WebModelPlugin.getDefault().logError((Throwable)e);
                    }
                    if (c == null) {
                        c = new LoadedDeclarations();
                    }
                    this.componentsLoaded(c, (IPath)new Path(p));
                }
            }
            ++i;
        }
        this.validateProjectDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcess() {
        int count = 0;
        while (this.isProcessed) {
            try {
                ClassPathMonitor classPathMonitor = this;
                synchronized (classPathMonitor) {
                    ((Object)((Object)this)).wait(100L);
                }
                if (++count < 50) continue;
                String message = "Failed to wait for class path build";
                WebKbPlugin.getDefault().logWarning(message, new Exception(message));
            }
            catch (InterruptedException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            break;
        }
    }

    public void validateProjectDependencies() {
        List<KbProject> ps = null;
        try {
            ps = this.getKbProjects(((KbProject)this.project).getProject());
        }
        catch (CoreException e) {
            WebModelPlugin.getDefault().logError((Throwable)e);
        }
        if (ps != null) {
            Set<KbProject> set = ((KbProject)this.project).getKbProjects();
            HashSet<KbProject> removable = new HashSet<KbProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (KbProject p : ps) {
                ((KbProject)this.project).addKbProject(p);
            }
            for (KbProject p : removable) {
                ((KbProject)this.project).removeKbProject(p);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasToUpdateProjectDependencies() {
        try {
            KbProject p;
            List<KbProject> ps = this.getKbProjects(((KbProject)this.project).getProject());
            Set<KbProject> set = ((KbProject)this.project).getKbProjects();
            if (set.size() != ps.size()) {
                return true;
            }
            Iterator<KbProject> iterator = ps.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (set.contains(p = iterator.next()));
            return true;
        }
        catch (CoreException e) {
            WebModelPlugin.getDefault().logError((Throwable)e);
        }
        return false;
    }

    void componentsLoaded(LoadedDeclarations c, IPath path) {
        if (c == null) {
            return;
        }
        ((KbProject)this.project).registerComponents(c, path);
    }

    List<KbProject> getKbProjects(IProject project) throws CoreException {
        ArrayList<KbProject> list = new ArrayList<KbProject>();
        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible()) {
                    KbProject.checkKBBuilderInstalled((IResource)p);
                    IKbProject sp = KbProjectFactory.getKbProject(p, false);
                    if (sp != null) {
                        list.add((KbProject)sp);
                    }
                }
                ++i;
            }
        }
        return list;
    }

    public void build() {
        this.waitProcess();
        if (this.update()) {
            this.process();
        } else if (this.hasToUpdateProjectDependencies()) {
            this.validateProjectDependencies();
        }
    }

    public void pathsChanged(List<String> paths) {
        super.pathsChanged(paths);
        if (((KbProject)this.project).isStorageResolved()) {
            XJob.addRunnableWithPriority((XJob.XRunnable)new XJob.XRunnable(){

                public void run() {
                    if (!ClassPathMonitor.this.isProcessed && ClassPathMonitor.this.update()) {
                        ClassPathMonitor.this.process();
                    }
                }

                public String getId() {
                    return "Update class path of kb project " + ((KbProject)ClassPathMonitor.this.project).getProject().getName();
                }
            });
        }
    }
}

