/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.jst.web.kb.IXmlContext;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;

public class XmlContextImpl
extends ELContextImpl
implements IXmlContext {
    protected Map<IRegion, Map<String, INameSpace>> nameSpaces = new HashMap<IRegion, Map<String, INameSpace>>();
    protected Set<String> uris = new HashSet<String>();

    public IDocument getDocument() {
        IDocument document = null;
        if (this.resource != null) {
            FileEditorInput editorInput = null;
            try {
                editorInput = new FileEditorInput(this.resource);
                document = this.getConnectedDocument((IEditorInput)editorInput);
            }
            catch (Throwable throwable) {
                this.releaseConnectedDocument((IEditorInput)editorInput);
                throw throwable;
            }
            this.releaseConnectedDocument((IEditorInput)editorInput);
        }
        return document;
    }

    public Map<String, List<INameSpace>> getNameSpaces(int offset) {
        HashMap<String, List<INameSpace>> result = new HashMap<String, List<INameSpace>>();
        HashMap<INameSpace, IRegion> namespaceToRegions = new HashMap<INameSpace, IRegion>();
        for (IRegion region : this.nameSpaces.keySet()) {
            Map<String, INameSpace> namespaces;
            if (offset < region.getOffset() || offset > region.getOffset() + region.getLength() || (namespaces = this.nameSpaces.get(region)) == null) continue;
            for (INameSpace ns : namespaces.values()) {
                INameSpace existingNameSpace = this.findNameSpaceByPrefix(namespaceToRegions.keySet(), ns.getPrefix());
                IRegion existingRegion = (IRegion)namespaceToRegions.get(existingNameSpace);
                if (existingRegion != null) {
                    if (region.getOffset() <= existingRegion.getOffset()) continue;
                    namespaceToRegions.remove(existingNameSpace);
                    namespaceToRegions.put(ns, region);
                    continue;
                }
                namespaceToRegions.put(ns, region);
            }
        }
        for (INameSpace ns : namespaceToRegions.keySet()) {
            ArrayList<INameSpace> list = (ArrayList<INameSpace>)result.get(ns.getURI());
            if (list == null) {
                list = new ArrayList<INameSpace>();
            }
            list.add(ns);
            result.put(ns.getURI(), list);
        }
        return result;
    }

    @Override
    public Map<String, List<INameSpace>> getRootNameSpaces() {
        int offset = Integer.MAX_VALUE;
        for (IRegion region : this.nameSpaces.keySet()) {
            if (offset <= region.getOffset()) continue;
            offset = region.getOffset();
        }
        return this.getNameSpaces(offset);
    }

    public INameSpace findNameSpaceByPrefix(Set<INameSpace> namespaces, String prefix) {
        if (namespaces != null && prefix != null) {
            for (INameSpace ns : namespaces) {
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        return null;
    }

    public void addNameSpace(IRegion region, INameSpace nameSpace) {
        Map<String, INameSpace> nameSpaceMap = this.nameSpaces.get(region);
        if (nameSpaceMap == null) {
            nameSpaceMap = new HashMap<String, INameSpace>();
            this.nameSpaces.put(region, nameSpaceMap);
        }
        nameSpaceMap.put(nameSpace.getPrefix(), nameSpace);
        String uri = nameSpace.getURI();
        if (!uri.isEmpty()) {
            this.uris.add(uri);
        }
    }

    @Override
    public Set<String> getURIs() {
        return this.uris;
    }

    private IDocument getConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return provider.getDocument((Object)input);
    }

    private void releaseConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        provider.disconnect((Object)input);
    }
}

