/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IFaceletPageContext;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.CustomProposalProcessorManager;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.taglib.CustomTagLibManager;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.IContextComponent;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibComponent;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.IFacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.kb.taglib.ITagLibRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibVersionRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class PageProcessor {
    private static final PageProcessor INSTANCE = new PageProcessor();
    private ICustomTagLibrary[] customTagLibs = CustomTagLibManager.getInstance().getLibraries();
    private Map<String, Set<ICustomTagLibrary>> customTagLibsByUri;
    private CustomTagLibAttribute[] componentExtensions = CustomTagLibManager.getInstance().getComponentExtensions();
    private static final IAttribute[] EMPTY_ATTRIBUTE_ARRAY = new IAttribute[0];

    public static PageProcessor getInstance() {
        return INSTANCE;
    }

    private PageProcessor() {
    }

    public TextProposal[] getProposals(KbQuery query, ELContext context) {
        return this.getProposals(query, context, false);
    }

    private List<TextProposal> excludeExtendedComponents(List<TextProposal> proposals) {
        HashMap<String, HashSet<TextProposal>> runtimeComponentMap = new HashMap<String, HashSet<TextProposal>>();
        HashMap<String, TextProposal> customComponentMap = new HashMap<String, TextProposal>();
        HashSet<TextProposal> customNotExtendedComponents = new HashSet<TextProposal>();
        for (TextProposal proposal : proposals) {
            Object source = proposal.getSource();
            if (!(source instanceof IComponent)) continue;
            IComponent component = (IComponent)source;
            String name = String.valueOf(component.getTagLib().getURI()) + ":" + component.getName();
            if (component instanceof ICustomTagLibComponent) {
                if (component.isExtended()) {
                    customComponentMap.put(name, proposal);
                    continue;
                }
                customNotExtendedComponents.add(proposal);
                continue;
            }
            HashSet<TextProposal> textProposals = (HashSet<TextProposal>)runtimeComponentMap.get(name);
            if (textProposals == null) {
                textProposals = new HashSet<TextProposal>();
            }
            textProposals.add(proposal);
            runtimeComponentMap.put(name, textProposals);
        }
        if (!customComponentMap.isEmpty()) {
            proposals.clear();
            for (String name : runtimeComponentMap.keySet()) {
                TextProposal customProposal = (TextProposal)customComponentMap.get(name);
                if (customProposal != null) {
                    proposals.add(customProposal);
                    continue;
                }
                proposals.addAll((Collection)runtimeComponentMap.get(name));
            }
            if (!customNotExtendedComponents.isEmpty()) {
                proposals.addAll(customNotExtendedComponents);
            }
        }
        return proposals;
    }

    public TextProposal[] getProposals(KbQuery query, ELContext context, boolean preferCustomComponentExtensions) {
        List<TextProposal> proposals;
        block15: {
            String value;
            block14: {
                List<TextProposal> customProposals;
                int j;
                proposals = new ArrayList<TextProposal>();
                if (this.isQueryForELProposals(query, context)) break block14;
                if (!(context instanceof IPageContext)) break block15;
                IPageContext pageContext = (IPageContext)context;
                ITagLibrary[] libs = pageContext.getLibraries();
                int i = 0;
                while (libs != null && i < libs.length) {
                    if (!(libs[i] instanceof IFacesConfigTagLibrary)) {
                        TextProposal[] libProposals = libs[i].getProposals(query, pageContext);
                        int j2 = 0;
                        while (libProposals != null && j2 < libProposals.length) {
                            proposals.add(libProposals[j2]);
                            ++j2;
                        }
                    }
                    ++i;
                }
                if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
                    HashMap<String, IAttribute> attrbMap = new HashMap<String, IAttribute>();
                    for (TextProposal proposal : proposals) {
                        if (proposal.getSource() == null || !(proposal.getSource() instanceof IAttribute)) continue;
                        IAttribute att = (IAttribute)proposal.getSource();
                        attrbMap.put(att.getName(), att);
                    }
                    IAttribute[] attrs = this.getAttributes(query, pageContext, false);
                    int i2 = 0;
                    while (i2 < attrs.length) {
                        attrbMap.put(attrs[i2].getName(), attrs[i2]);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < this.componentExtensions.length) {
                        if (attrbMap.containsKey(this.componentExtensions[i2].getName())) {
                            TextProposal[] attProposals = this.componentExtensions[i2].getProposals(query, pageContext);
                            j = 0;
                            while (j < attProposals.length) {
                                proposals.add(attProposals[j]);
                                ++j;
                            }
                        }
                        ++i2;
                    }
                }
                Set<ICustomTagLibrary> customTagLibSet = this.getCustomTagLibs(pageContext);
                for (ICustomTagLibrary lib : customTagLibSet) {
                    TextProposal[] libProposals = lib.getProposals(query, pageContext);
                    j = 0;
                    while (libProposals != null && j < libProposals.length) {
                        proposals.add(libProposals[j]);
                        ++j;
                    }
                }
                if (preferCustomComponentExtensions && query.getType() == KbQuery.Type.TAG_NAME) {
                    proposals = this.excludeExtendedComponents(proposals);
                }
                if ((customProposals = CustomProposalProcessorManager.getInstance().getProposals(query, pageContext)).size() <= 0) break block15;
                proposals.addAll(customProposals);
                break block15;
            }
            String elString = value = query.getValue();
            ELResolver[] resolvers = context.getElResolvers();
            int i = 0;
            while (resolvers != null && i < resolvers.length) {
                List pls = resolvers[i].getProposals(context, elString, query.getOffset());
                if (pls != null) {
                    proposals.addAll(pls);
                }
                ++i;
            }
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    private Set<ICustomTagLibrary> getCustomTagLibs(ELContext context) {
        HashSet<ICustomTagLibrary> result = new HashSet<ICustomTagLibrary>();
        if (this.customTagLibsByUri == null) {
            this.customTagLibsByUri = new HashMap<String, Set<ICustomTagLibrary>>();
            int i = 0;
            while (this.customTagLibs != null && i < this.customTagLibs.length) {
                Set<ICustomTagLibrary> libs = this.customTagLibsByUri.get(this.customTagLibs[i].getURI());
                if (libs == null) {
                    libs = new HashSet<ICustomTagLibrary>();
                    this.customTagLibsByUri.put(this.customTagLibs[i].getURI(), libs);
                }
                libs.add(this.customTagLibs[i]);
                ++i;
            }
        }
        for (Set<ICustomTagLibrary> libs : this.customTagLibsByUri.values()) {
            if (libs.size() == 1) {
                ICustomTagLibrary lib = libs.iterator().next();
                if (!this.shouldLoadLib(lib, context)) continue;
                result.add(lib);
                continue;
            }
            if (libs.size() <= 1) continue;
            ICustomTagLibrary any = libs.iterator().next();
            ITagLibRecognizer recognizer = any.getRecognizer();
            IHTMLLibraryVersion version = null;
            if (recognizer != null && recognizer instanceof ITagLibVersionRecognizer && (version = ((ITagLibVersionRecognizer)recognizer).getVersion(context)) == null) continue;
            for (ICustomTagLibrary lib : libs) {
                String v = lib.getVersion();
                if (version == null || v == null || lib.getRecognizer() == null) {
                    if (!this.shouldLoadLib(lib, context)) continue;
                    result.add(lib);
                    continue;
                }
                if (!version.toString().equals(v)) continue;
                result.add(lib);
            }
        }
        return result;
    }

    private boolean shouldLoadLib(ICustomTagLibrary lib, ELContext context) {
        ITagLibRecognizer recognizer = lib.getRecognizer();
        return recognizer == null || recognizer.shouldBeLoaded(lib, context);
    }

    private boolean isQueryForELProposals(KbQuery query, ELContext context) {
        if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE || query.getType() == KbQuery.Type.TEXT && (context instanceof IFaceletPageContext || context instanceof XmlContextImpl)) {
            boolean isELStarted;
            String text = query.getValue();
            if (text == null) {
                return false;
            }
            int inValueOffset = text.length();
            if (text.length() < inValueOffset) {
                return false;
            }
            if (inValueOffset < 0) {
                return false;
            }
            ELParser p = ELParserUtil.getJbossFactory().createParser();
            ELModel model = p.parse(text);
            ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
            boolean bl = isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
            if (!isELStarted) {
                return false;
            }
            boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
            return !isELClosed;
        }
        return false;
    }

    public IComponent[] getComponents(KbQuery query, IPageContext context) {
        return this.getComponents(query, context, false);
    }

    public IComponent[] getComponents(KbQuery query, IPageContext context, boolean includeComponentExtensions) {
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        ITagLibrary[] libs = context.getLibraries();
        int i = 0;
        while (i < libs.length) {
            if (!(libs[i] instanceof IFacesConfigTagLibrary)) {
                IComponent[] libComponents = libs[i].getComponents(query, context);
                int j = 0;
                while (j < libComponents.length) {
                    if (includeComponentExtensions || !libComponents[j].isExtended()) {
                        components.add(libComponents[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Set<ICustomTagLibrary> customTagLibSet = this.getCustomTagLibs(context);
        for (ICustomTagLibrary lib : customTagLibSet) {
            IComponent[] libComponents = lib.getComponents(query, context);
            int j = 0;
            while (j < libComponents.length) {
                if (includeComponentExtensions || !libComponents[j].isExtended()) {
                    components.add(libComponents[j]);
                }
                ++j;
            }
        }
        return components.toArray(new IComponent[components.size()]);
    }

    public IAttribute[] getAttributes(KbQuery query, IPageContext context) {
        return this.getAttributes(query, context, true);
    }

    private IAttribute[] getAttributes(KbQuery query, IPageContext context, boolean includeComponentExtensions) {
        if (query.getType() == KbQuery.Type.ATTRIBUTE_NAME || query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
            HashMap<String, IAttribute> attrbMap = new HashMap<String, IAttribute>();
            IComponent[] components = this.getComponents(query, context, includeComponentExtensions);
            int i = 0;
            while (i < components.length) {
                IComponent component = components[i];
                IAttribute[] libAttributess = component instanceof IContextComponent ? ((IContextComponent)component).getAttributes(context, query, true) : component.getAttributes(query, context);
                if (libAttributess != null) {
                    int j = 0;
                    while (j < libAttributess.length) {
                        attributes.add(libAttributess[j]);
                        attrbMap.put(libAttributess[j].getName(), libAttributess[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (includeComponentExtensions) {
                i = 0;
                while (i < this.componentExtensions.length) {
                    if (attrbMap.containsKey(this.componentExtensions[i].getName())) {
                        attributes.add(this.componentExtensions[i]);
                    }
                    ++i;
                }
            }
            return attributes.toArray(new IAttribute[attributes.size()]);
        }
        return EMPTY_ATTRIBUTE_ARRAY;
    }

    public Map<String, IAttribute> getAttributesAsMap(KbQuery query, IPageContext context) {
        IAttribute[] as = this.getAttributes(query, context);
        HashMap<String, IAttribute> map = new HashMap<String, IAttribute>();
        IAttribute[] iAttributeArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String n3;
                IAttribute a;
                block3: {
                    a = iAttributeArray[n2];
                    n3 = a.getName();
                    if (!map.containsKey(n3)) break block3;
                    IAttribute o = (IAttribute)map.get(n3);
                    int pa = a.isPreferable() || a.isRequired() ? 2 : 0;
                    int po = o.isPreferable() || o.isRequired() ? 2 : 0;
                    if ((pa += a instanceof CustomTagLibAttribute ? 1 : 0) <= (po += o instanceof CustomTagLibAttribute ? 1 : 0)) break block4;
                }
                map.put(n3, a);
            }
            ++n2;
        }
        return map;
    }
}

