/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyModifiablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReferenceTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedReferenceTable;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInReferenceTableDialog;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInReferenceTableStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.TableCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceTableComposite<T extends ReferenceTable>
extends Pane<T> {
    protected Button overrideDefaultJoinColumnsCheckBox;
    protected JoinColumnsComposite<T> joinColumnsComposite;
    static final Collection<String> SCHEMA_PICK_LIST_PROPERTIES = Arrays.asList("defaultCatalog", "specifiedCatalog");
    static final Collection<String> TABLE_PICK_LIST_PROPERTIES = Arrays.asList((String[])ArrayTools.addAll((Object[])SCHEMA_PICK_LIST_PROPERTIES.toArray(new String[0]), (Object[])new String[]{"defaultSchema", "specifiedSchema"}));

    protected ReferenceTableComposite(Pane<?> parentPane, PropertyValueModel<? extends T> tableModel, Composite parentComposite) {
        super(parentPane, tableModel, parentComposite);
    }

    protected ReferenceTableComposite(Pane<?> parentPane, PropertyValueModel<? extends T> tableModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite) {
        super(parentPane, tableModel, enabledModel, parentComposite);
    }

    protected PropertyValueModel<Boolean> buildJoinColumnsEnabledModel() {
        return new JoinColumnsEnabledModel();
    }

    SpecifiedJoinColumn addJoinColumn(T referenceTable) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), this.getResourceManager(), (ReferenceTable)referenceTable);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.wasConfirmed() ? this.addJoinColumnFromDialog((JoinColumnInReferenceTableStateObject)dialog.getSubject()) : null;
    }

    SpecifiedJoinColumn addJoinColumnFromDialog(JoinColumnInReferenceTableStateObject stateObject) {
        SpecifiedJoinColumn joinColumn = ((SpecifiedReferenceTable)this.getSubject()).addSpecifiedJoinColumn();
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)joinColumn);
        return joinColumn;
    }

    protected JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    protected ModifiablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumns"}){

            protected ListIterable<JoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((ReferenceTable)this.subject).getSpecifiedJoinColumns());
            }

            protected int size_() {
                return ((ReferenceTable)this.subject).getSpecifiedJoinColumnsSize();
            }
        };
    }

    protected CatalogCombo<T> addCatalogCombo(Composite container, final String helpId) {
        return new CatalogCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultCatalog();
            }

            protected void setValue(String value) {
                ((SpecifiedReferenceTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedCatalog();
            }

            protected String getHelpId() {
                return helpId;
            }
        };
    }

    protected SchemaCombo<T> addSchemaCombo(Composite container, final String helpId) {
        return new SchemaCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.addAll(SCHEMA_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (SCHEMA_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultSchema();
            }

            protected void setValue(String value) {
                ((SpecifiedReferenceTable)this.getSubject()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedSchema();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer_() {
                SpecifiedReferenceTable table = this.getTable();
                return table == null ? null : table.getDbSchemaContainer();
            }

            protected SpecifiedReferenceTable getTable() {
                ReferenceTable table = (ReferenceTable)this.getSubject();
                return table instanceof SpecifiedReferenceTable ? (SpecifiedReferenceTable)table : null;
            }

            protected String getHelpId() {
                return helpId;
            }
        };
    }

    protected TableCombo<T> addTableCombo(Composite container, final String helpId) {
        return new TableCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.addAll(TABLE_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (TABLE_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((SpecifiedReferenceTable)this.getSubject()).setSpecifiedName(value);
            }

            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedName();
            }

            @Override
            protected Schema getDbSchema_() {
                SpecifiedReferenceTable table = this.getTable();
                return table == null ? null : table.getDbSchema();
            }

            protected SpecifiedReferenceTable getTable() {
                ReferenceTable table = (ReferenceTable)this.getSubject();
                return table instanceof SpecifiedReferenceTable ? (SpecifiedReferenceTable)table : null;
            }

            protected String getHelpId() {
                return helpId;
            }
        };
    }

    void editJoinColumn(JoinColumn joinColumn) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), this.getResourceManager(), (ReferenceTable)this.getSubject(), joinColumn);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.editJoinColumn((JoinColumnInReferenceTableStateObject)dialog.getSubject());
        }
    }

    void editJoinColumn(JoinColumnInReferenceTableStateObject stateObject) {
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)stateObject.getJoinColumn());
    }

    void updateJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        SpecifiedReferenceTable referenceTable = (SpecifiedReferenceTable)this.getSubject();
        if (referenceTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                referenceTable.convertDefaultJoinColumnToSpecified();
                this.setSelectedJoinColumn(referenceTable.getSpecifiedJoinColumn(0));
            } else {
                referenceTable.clearSpecifiedJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    private void setSelectedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.joinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    protected abstract boolean tableIsVirtual(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsEnabledModel
    extends TransformationPropertyValueModel<T, Boolean> {
        private StateChangeListener stateChangeListener;

        JoinColumnsEnabledModel() {
            super((PropertyValueModel)new ValueListAdapter((ModifiablePropertyValueModel)new ReadOnlyModifiablePropertyValueModelWrapper(ReferenceTableComposite.this.getSubjectHolder()), new String[]{"specifiedJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    JoinColumnsEnabledModel.this.valueStateChanged();
                }
            };
        }

        void valueStateChanged() {
            Object old = this.value;
            this.value = this.transform((T)((ReferenceTable)this.valueModel.getValue()));
            this.firePropertyChanged("value", old, this.value);
        }

        protected Boolean transform(T v) {
            return v == null ? Boolean.FALSE : (Boolean)super.transform(v);
        }

        protected Boolean transform_(T v) {
            boolean virtual = ReferenceTableComposite.this.tableIsVirtual(v);
            return !virtual && v.getSpecifiedJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueModel.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageModel() {
            this.valueModel.removeStateChangeListener(this.stateChangeListener);
            super.disengageModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<T> {
        JoinColumnsProvider() {
        }

        @Override
        public SpecifiedJoinColumn addJoinColumn(T subject) {
            return ReferenceTableComposite.this.addJoinColumn(subject);
        }

        @Override
        public JoinColumn getDefaultJoinColumn(T subject) {
            return subject.getDefaultJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultJoinColumn";
        }

        @Override
        public void editJoinColumn(T subject, JoinColumn joinColumn) {
            ReferenceTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(T subject) {
            return subject.hasSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumn(T subject, SpecifiedJoinColumn joinColumn) {
            ((SpecifiedReferenceTable)subject).removeSpecifiedJoinColumn(joinColumn);
        }

        @Override
        public ListIterable<JoinColumn> getSpecifiedJoinColumns(T subject) {
            return new SuperListIterableWrapper(subject.getSpecifiedJoinColumns());
        }

        @Override
        public int getSpecifiedJoinColumnsSize(T subject) {
            return subject.getSpecifiedJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements ModifiablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(ReferenceTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listModel.size() > 0;
        }

        public void setValue(Boolean value) {
            ReferenceTableComposite.this.updateJoinColumns();
        }
    }
}

