/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.xml.form;

import java.util.ArrayList;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.ui.forms.FormActionData;
import org.jboss.tools.common.model.ui.forms.FormAttributeData;
import org.jboss.tools.common.model.ui.forms.FormData;
import org.jboss.tools.common.model.ui.forms.IFormActionData;
import org.jboss.tools.common.model.ui.forms.IFormAttributeData;
import org.jboss.tools.common.model.ui.forms.ILayoutDataFactory;
import org.jboss.tools.common.model.ui.forms.InfoLayoutDataFactory;

public class Hibernate3FormLayoutDataUtil {
    private static final String STBFE_CLASS_NAME = "org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkLineFieldEditor";
    public static final String SBFEE_CLASS_NAME = "org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx";
    private static final String SELECT_IT_ACTION = "%SelectIt%";
    private static final String INTERNAL_ACTION = "%internal%";
    private static final String DEFAULT_DELETE_ACTION = "DeleteActions.Delete";

    public static IFormAttributeData[] createGeneralFormAttributeData(String entityName) {
        return Hibernate3FormLayoutDataUtil.createFormAttributeData(entityName, "general");
    }

    public static IFormAttributeData[] createAdvancedFormAttributeData(String entityName) {
        return Hibernate3FormLayoutDataUtil.createFormAttributeData(entityName, "advanced");
    }

    public static IFormAttributeData[] createFormAttributeData(String entityName, String categoryName) {
        XModelEntity entity = XModelMetaDataImpl.getInstance().getEntity(entityName);
        if (entity == null) {
            return new IFormAttributeData[0];
        }
        ArrayList<FormAttributeData> list = new ArrayList<FormAttributeData>();
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String category;
            if (as[i].isVisible() && (category = as[i].getProperty("category")) != null && category.equals(categoryName)) {
                String editorName = as[i].getEditor().getName();
                if ("AccessibleJava".equals(editorName)) {
                    list.add(new FormAttributeData(as[i].getName(), null, STBFE_CLASS_NAME));
                } else if ("Note".equals(editorName)) {
                    list.add(new FormAttributeData(as[i].getName(), (ILayoutDataFactory)InfoLayoutDataFactory.getInstance()));
                } else {
                    list.add(new FormAttributeData(as[i].getName()));
                }
            }
            ++i;
        }
        return list.toArray(new IFormAttributeData[0]);
    }

    public static String[] getChildEntitiesWithAttribute(String entityName, String attributeName) {
        XModelEntity entity = XModelMetaDataImpl.getInstance().getEntity(entityName);
        if (entity == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        XChild[] cs = entity.getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelEntity c = entity.getMetaModel().getEntity(cs[i].getName());
            if (c != null && c.getAttribute(attributeName) != null) {
                list.add(c.getName());
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static FormData createAllChildrenFormData(String name, String entityName, String childName, String attributeName, String createAction) {
        return Hibernate3FormLayoutDataUtil.createChildrenFormData(name, entityName, childName, attributeName, Hibernate3FormLayoutDataUtil.getChildEntitiesWithAttribute(entityName, attributeName), createAction);
    }

    public static FormData createChildrenFormData(String name, String entityName, String childName, String attributeName, String[] entityNames, String createAction) {
        return new FormData(name, "", childName != null ? childName : entityName, (IFormAttributeData[])new FormAttributeData[]{new FormAttributeData(attributeName, 100, attributeName)}, entityNames, Hibernate3FormLayoutDataUtil.createDefaultFormActionData(createAction));
    }

    public static IFormActionData[] createDefaultFormActionData(String actionPath) {
        return new IFormActionData[]{new FormActionData("ADD_ACTION", actionPath), new FormActionData("REMOVE_ACTION", DEFAULT_DELETE_ACTION), new FormActionData("EDIT_ACTION", SELECT_IT_ACTION), new FormActionData("UP_ACTION", INTERNAL_ACTION), new FormActionData("DOWN_ACTION", INTERNAL_ACTION)};
    }
}

