/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.xml.editor;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.editor.TreeFormPage;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.model.ui.editors.multipage.DefaultMultipageEditor;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorComponent;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.hibernate.ui.xml.HibernateUIXMLPlugin;
import org.jboss.tools.hibernate.ui.xml.Messages;
import org.jboss.tools.hibernate.xml.model.FileHibernateFilteredTreeConstraint;

public class HibConfig3CompoundEditor
extends DefaultMultipageEditor {
    protected TreeFormPage sessionFactory;
    protected TreeFormPage security;

    protected void doCreatePages() {
        if (this.isAppropriateNature()) {
            this.sessionFactory = this.createTreeFormPage();
            this.sessionFactory.setLabel(Messages.HibConfig3CompoundEditor_SessionFactoryLabel);
            this.sessionFactory.setTitle(Messages.HibConfig3CompoundEditor_SessionFactoryTitle);
            this.sessionFactory.addFilter((XFilteredTreeConstraint)new FileHibernateFilteredTreeConstraint());
            this.sessionFactory.initialize((Object)this.getSessionFactoryObject());
            this.addFormPage(this.sessionFactory, "sessionFactoryEditor");
            this.security = this.createTreeFormPage();
            this.security.setLabel(Messages.HibConfig3CompoundEditor_SecurityLabel);
            this.security.setTitle(Messages.HibConfig3CompoundEditor_SecurityTitle);
            this.security.addFilter((XFilteredTreeConstraint)new FileHibernateFilteredTreeConstraint());
            this.security.initialize((Object)this.getSecurityObject());
            this.addFormPage(this.security, "securityEditor");
        }
        this.createTextPage();
        this.initEditors();
        if (this.treeFormPage != null) {
            this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider());
        }
        if (this.sessionFactory != null) {
            this.selectionProvider.addHost("sessionFactoryEditor", this.sessionFactory.getSelectionProvider());
        }
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", (ISelectionProvider)this.getTextSelectionProvider());
        }
    }

    protected void addFormPage(TreeFormPage formPage, String name) {
        try {
            int index = this.addPage((IEditorPart)formPage, this.getEditorInput());
            this.setPageText(index, formPage.getLabel());
            this.selectionProvider.addHost(name, formPage.getSelectionProvider());
            formPage.getEditorSite().getKeyBindingService();
        }
        catch (Exception ex) {
            HibernateUIXMLPlugin.log(ex);
        }
    }

    protected void setNormalMode() {
        if (this.treeFormPage != null) {
            this.sessionFactory.initialize((Object)this.getSessionFactoryObject());
            this.sessionFactory.setErrorMode(this.isErrorMode());
            this.security.initialize((Object)this.getSecurityObject());
            this.security.setErrorMode(this.isErrorMode());
        }
        if (this.selectionProvider != null) {
            this.updateSelectionProvider();
        }
        if (this.treeEditor != null) {
            this.treeEditor.setObject(this.object, this.isErrorMode());
        }
    }

    XModelObject getSessionFactoryObject() {
        XModelObject o = this.getModelObject().getChildByPath("Session Factory");
        if (o == null) {
            o = XModelObjectLoaderUtil.createValidObject((XModel)this.object.getModel(), (String)"HibConfig3SessionFactory");
        }
        return o;
    }

    XModelObject getSecurityObject() {
        XModelObject o = this.getModelObject().getChildByPath("Security");
        if (o == null) {
            o = XModelObjectLoaderUtil.createValidObject((XModel)this.object.getModel(), (String)"HibConfig3Security");
        }
        return o;
    }

    protected void setErrorMode() {
        if (this.treeFormPage != null) {
            this.sessionFactory.initialize((Object)this.getSessionFactoryObject());
            this.sessionFactory.setErrorMode(this.isErrorMode());
            this.security.initialize((Object)this.getSecurityObject());
            this.security.setErrorMode(this.isErrorMode());
        }
        if (this.treeEditor != null) {
            this.treeEditor.setObject(this.object, this.isErrorMode());
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EditorDescriptor.class) {
            return new EditorDescriptor("HibernateConfiguration3.0");
        }
        return super.getAdapter(adapter);
    }

    protected XMLTextEditorComponent createTextEditorComponent() {
        return new XMLTextEditorComponent(false);
    }
}

