/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import tern.eclipse.ide.internal.ui.Trace;

public class BrowserSupport {
    public static void open(final URL url, Display display) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                BrowserSupport.internalOpen(url, false);
            }
        });
    }

    public static void openExternal(final URL url, Display display) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                BrowserSupport.internalOpen(url, true);
            }
        });
    }

    private static void internalOpen(final URL url, final boolean useExternalBrowser) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                URL helpSystemUrl = PlatformUI.getWorkbench().getHelpSystem().resolve(url.toExternalForm(), true);
                if (helpSystemUrl == null) {
                    return;
                }
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = useExternalBrowser ? browserSupport.getExternalBrowser() : browserSupport.createBrowser(null);
                    browser.openURL(helpSystemUrl);
                }
                catch (PartInitException ex) {
                    Trace.trace((byte)3, "Opening Javadoc failed", ex);
                }
            }
        });
    }

    public static void setLinkTarget(Link link, String target, final String url) {
        link.setText("<a>" + target + "</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    BrowserSupport.open(new URL(url), event.display);
                }
                catch (MalformedURLException e) {
                    Trace.trace((byte)3, "Error while opening browser", e);
                }
            }
        });
    }
}

