/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tern.eclipse.ide.core.IWorkingCopy;
import tern.eclipse.ide.core.IWorkingCopyListener;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.eclipse.ide.ui.properties.AbstractTernPropertyPage;
import tern.server.ITernModule;

public class TernModulesPropertyPage
extends AbstractTernPropertyPage
implements IWorkbenchPreferencePage,
IWorkingCopyListener {
    public static final String PAGE_ID = "tern.eclipse.ide.ui.properties.modules";
    private TernModulesBlock modulesBlock;

    public TernModulesPropertyPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(TernUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayoutData((Object)new GridData(1808));
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        IResource resource = this.getResource();
        this.modulesBlock = new TernModulesBlock(resource != null ? resource.getProject() : null, TernUIMessages.TernModulesPropertyPage_desc);
        Control control = this.modulesBlock.createControl(parent);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.refreshModules();
        this.applyDialogFont(parent);
        return parent;
    }

    public void refreshModules() {
        try {
            IWorkingCopy workingCopy = this.getWorkingCopy();
            workingCopy.addWorkingCopyListener((IWorkingCopyListener)this);
            this.modulesBlock.refresh(workingCopy.getAllModules(), workingCopy.getCheckedModules());
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Error while loading tern project", e);
        }
    }

    public boolean performOk() {
        this.modulesBlock.saveColumnSettings();
        try {
            this.saveWorkingCopy();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
        return super.performOk();
    }

    public void moduleSelectionChanged(ITernModule module, boolean selected) {
        if (!this.modulesBlock.isCheckUpdating()) {
            this.modulesBlock.setCheckedModule(module, selected);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.getWorkingCopy().removeWorkingCopyListener((IWorkingCopyListener)this);
        }
        catch (Throwable throwable) {}
    }
}

