/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.hover.AbstractTernHover;
import tern.eclipse.ide.ui.hover.HTMLTernTypeCollector;
import tern.eclipse.ide.ui.hover.IDEHoverControlCreator;
import tern.eclipse.ide.ui.hover.IDEPresenterControlCreator;
import tern.eclipse.ide.ui.hover.ITernHoverInfoProvider;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.jface.text.TernBrowserInformationControlInput;
import tern.server.protocol.TernQuery;
import tern.server.protocol.type.ITernTypeCollector;
import tern.server.protocol.type.TernTypeQuery;

public class TernHover
extends AbstractTernHover
implements ITextHoverExtension,
ITextHoverExtension2,
IInformationProviderExtension2,
ITernHoverInfoProvider {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private IIDETernProject ternProject;
    private Integer offset;
    private ITernFile file;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        TernBrowserInformationControlInput info = (TernBrowserInformationControlInput)this.getHoverInfo2(textViewer, hoverRegion);
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.ternProject = null;
        this.offset = null;
        IFile scriptFile = this.getFile(textViewer);
        if (scriptFile == null) {
            return null;
        }
        IProject project = scriptFile.getProject();
        if (TernCorePlugin.hasTernNature((IProject)project)) {
            try {
                this.ternProject = TernCorePlugin.getTernProject((IProject)project);
                this.file = new TernDocumentFile(scriptFile, textViewer.getDocument());
                String filename = this.file.getFullName((ITernProject)this.ternProject);
                this.offset = hoverRegion.getOffset();
                TernTypeQuery query = new TernTypeQuery(filename, this.offset);
                query.setDocs(true);
                query.setUrls(true);
                query.setTypes(true);
                HTMLTernTypeCollector collector = new HTMLTernTypeCollector(this.ternProject);
                this.ternProject.request((TernQuery)query, this.file, (ITernTypeCollector)collector);
                return new TernBrowserInformationControlInput(null, collector.getInfo(), 20);
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Error while tern hyperlink", e);
            }
        }
        return null;
    }

    protected IFile getFile(ITextViewer textViewer) {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            return EditorUtils.getFile(editor);
        }
        return EditorUtils.getFile(textViewer.getDocument());
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new IDEHoverControlCreator(this.getInformationPresenterControlCreator(), this);
        }
        return this.fHoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new IDEPresenterControlCreator(this);
        }
        return this.fPresenterControlCreator;
    }

    public IIDETernProject getTernProject() {
        return this.ternProject;
    }

    @Override
    public ITernFile getFile() {
        return this.file;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }
}

