/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.hyperlink;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.hyperlink.TernHyperlink;
import tern.eclipse.ide.ui.utils.EditorUtils;

public class TernHyperLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return null;
        }
        IResource resource = EditorUtils.getResource((IEditorPart)textEditor);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (TernCorePlugin.hasTernNature((IProject)project)) {
            try {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                IDocument document = textViewer.getDocument();
                TernHyperlink hyperlink = new TernHyperlink(document, region, resource, ternProject);
                IHyperlink[] hyperlinks = new IHyperlink[]{hyperlink};
                return hyperlinks;
            }
            catch (CoreException e) {
                Trace.trace((byte)2, "Error while tern hyperlink", e);
            }
        }
        return null;
    }
}

