/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchConstants;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.preferences.BatchSeverityPreferences;
import org.jboss.tools.batch.internal.core.validation.BatchValidationMessages;
import org.jboss.tools.batch.internal.core.validation.JobTransitionsValidator;
import org.jboss.tools.batch.internal.core.validation.SimpleReference;
import org.jboss.tools.batch.internal.core.validation.TransitionsValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.ITypedReporter;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BatchValidator
extends KBValidator
implements BatchConstants,
IStringValidator {
    public static final String ID = "org.jboss.tools.batch.validator.BatchValidator";
    public static String SHORT_ID = "batch-verification";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.batch.ui.preferences.BatchValidationPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.batch.ui.propertyPages.BatchValidationPreferencePage";
    String projectName;
    Map<IProject, IProjectValidationContext> contexts = new HashMap<IProject, IProjectValidationContext>();
    static String[] EXECUTION_ELEMENTS = new String[]{"decision", "flow", "split", "step"};
    static String JOB_PROPERTY_CALL_START = "#{jobProperties['";
    static String JOB_PROPERTY_CALL_END = "'";
    private static final String BUNDLE_NAME = "org.jboss.tools.batch.internal.core.validation.messages";

    protected String getPreference(IProject project, String preferenceKey) {
        return BatchSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return BatchSeverityPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.setAsYouTypeValidation(false);
        this.projectName = project.getName();
        this.contexts.clear();
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return KbBuilder.BUILDER_ID;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        Object rootContext = this.contexts.get(project);
        if (rootContext == null) {
            IKbProject kb = KbProjectFactory.getKbProject((IProject)project, (boolean)true);
            rootContext = kb != null ? kb.getValidationContext() : new ProjectValidationContext();
            this.contexts.put(project, (IProjectValidationContext)rootContext);
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean shouldValidate(IProject project) {
        return this.shouldValidate(project, false);
    }

    public boolean shouldValidateAsYouType(IProject project) {
        return this.shouldValidate(project, true);
    }

    public boolean shouldValidate(IProject project, boolean asYouType) {
        try {
            return project.isAccessible() && BatchCorePlugin.getBatchProject(project, true) != null && this.isEnabled(project) && (asYouType || this.validateBuilderOrder(project));
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
            return false;
        }
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return true;
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        BatchProject batchProject = BatchProjectFactory.getBatchProject(project, true);
        HashSet<IPath> resourcesToClean = new HashSet<IPath>();
        for (IFile file : changedFiles) {
            resourcesToClean.add(file.getFullPath());
        }
        changedFiles = this.collectFiles(project, changedFiles, context);
        for (IFile file : changedFiles) {
            this.removeAllMessagesFromResource((IResource)file);
            resourcesToClean.add(file.getFullPath());
        }
        this.getValidationContext().removeLinkedCoreResources(SHORT_ID, resourcesToClean);
        Set<IFile> batchJobs = batchProject.getDeclaredBatchJobs();
        for (IFile file : changedFiles) {
            if (!batchJobs.contains(file)) continue;
            this.validateJobFile(batchProject, file);
        }
        this.cleanSavedMarkers();
        return this.OK_STATUS;
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(BatchValidationMessages.VALIDATING_PROJECT, new String[]{this.projectName});
        BatchProject batchProject = BatchProjectFactory.getBatchProject(project, true);
        if (batchProject != null) {
            Set<IFile> batchJobs = batchProject.getDeclaredBatchJobs();
            for (IFile file : batchJobs) {
                this.validateJobFile(batchProject, file);
            }
        }
        this.cleanSavedMarkers();
        return this.OK_STATUS;
    }

    public void validate(IValidator validatorManager, IProject rootProject, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, EditorValidationContext validationContext, IProjectValidationContext projectContext, IFile file) {
        ContextValidationHelper validationHelper = new ContextValidationHelper();
        validationHelper.setProject(rootProject);
        validationHelper.setValidationContextManager((IValidationContextManager)validationContext);
        this.init(rootProject, validationHelper, projectContext, validatorManager, reporter);
        this.setAsYouTypeValidation(true);
        ++this.asYouTypeTimestamp;
        this.document = validationContext.getDocument();
        IBatchProject batchProject = BatchCorePlugin.getBatchProject(file.getProject(), true);
        if (batchProject != null && batchProject.getDeclaredBatchJobs().contains(file)) {
            this.validateJobFile(batchProject, file);
        }
        if (reporter instanceof ITypedReporter) {
            ((ITypedReporter)reporter).addTypeForFile(this.getProblemType());
        }
        this.disableProblemAnnotations(new IRegion(){

            public int getOffset() {
                return 0;
            }

            public int getLength() {
                return BatchValidator.this.document.getLength();
            }
        }, reporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateJobFile(IBatchProject batchProject, IFile file) {
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) return;
        IStructuredModel model = null;
        try {
            try {
                Element element;
                IDOMModel domModel;
                IDOMDocument document;
                IStructuredModel iStructuredModel = model = file != null ? manager.getModelForRead(file) : manager.getExistingModelForRead(this.document);
                if (!(model instanceof IDOMModel) || (document = (domModel = (IDOMModel)model).getDocument()) == null || (element = document.getDocumentElement()) == null || !"job".equals(element.getNodeName())) return;
                this.validateJobElement(batchProject, file, element);
                return;
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    IMarker addProblem(String message, String preferenceKey, Element element, String attr, IFile file, int quickfixId) {
        SimpleReference ref = new SimpleReference(element, attr, file);
        if (quickfixId == -1) {
            return this.addProblem(message, preferenceKey, new String[]{element.getAttribute(attr).trim()}, ref.getLength(), ref.getStartPosition(), (IResource)file);
        }
        return this.addProblem(message, preferenceKey, new String[]{element.getAttribute(attr).trim()}, ref.getLength(), ref.getStartPosition(), (IResource)file, quickfixId);
    }

    private void validateJobElement(IBatchProject batchProject, IFile file, Element job) {
        Element listeners;
        ContextProperties cp = new ContextProperties(null, job, file);
        String restartable = job.getAttribute("restartable");
        if (!(restartable == null || restartable.trim().length() <= 0 || "true".equals(restartable) || "false".equals(restartable) || restartable.startsWith("#{"))) {
            this.addProblem(BatchValidationMessages.JOB_RESTARTABLE_IS_NOT_BOOLEAN, BatchSeverityPreferences.INVALID_JOB_RESTARTABLE, job, "restartable", file, -1);
        }
        if ((listeners = XMLUtilities.getUniqueChild((Element)job, (String)"listeners")) != null) {
            Element[] elementArray = XMLUtilities.getChildren((Element)listeners, (String)"listener");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element listener = elementArray[n2];
                this.validateRefAndProperties(batchProject, file, cp, listener, BatchArtifactType.JOB_LISTENER, BatchValidationMessages.JOB_LISTENER_IS_NOT_FOUND, BatchValidationMessages.JOB_LISTENER_IS_EXPECTED);
                ++n2;
            }
        }
        this.validateFlowElement(batchProject, file, cp, job, null);
        cp.complete(null);
    }

    private void validateFlowElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element flow, JobTransitionsValidator jobTransitions) {
        TransitionsValidator transitionValidator = null;
        if (jobTransitions == null) {
            jobTransitions = new JobTransitionsValidator(this);
            transitionValidator = jobTransitions;
        } else {
            transitionValidator = new TransitionsValidator(this, jobTransitions);
        }
        Object[] objectArray = EXECUTION_ELEMENTS;
        int n = EXECUTION_ELEMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = objectArray[n2];
            Element[] elementArray = XMLUtilities.getChildren((Element)flow, (String)tag);
            int n3 = elementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Element decision = elementArray[n4];
                transitionValidator.addFlowElement(decision);
                ++n4;
            }
            ++n2;
        }
        transitionValidator.validate(file);
        objectArray = XMLUtilities.getChildren((Element)flow, (String)"decision");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object decision = objectArray[n2];
            this.validateDecisionElement(batchProject, file, cp, (Element)decision);
            ++n2;
        }
        objectArray = XMLUtilities.getChildren((Element)flow, (String)"flow");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object flow1 = objectArray[n2];
            this.validateFlowElement(batchProject, file, cp, (Element)flow1, jobTransitions);
            ++n2;
        }
        objectArray = XMLUtilities.getChildren((Element)flow, (String)"split");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object split = objectArray[n2];
            this.validateFlowElement(batchProject, file, cp, (Element)split, jobTransitions);
            ++n2;
        }
        objectArray = XMLUtilities.getChildren((Element)flow, (String)"step");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object step = objectArray[n2];
            this.validateStepElement(batchProject, file, cp, (Element)step);
            ++n2;
        }
    }

    private void validateStepElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element step) {
        Element listeners;
        ContextProperties cp1 = new ContextProperties(cp, step, file);
        Element batchlet = XMLUtilities.getUniqueChild((Element)step, (String)"batchlet");
        Element chunk = XMLUtilities.getUniqueChild((Element)step, (String)"chunk");
        if (batchlet != null) {
            this.validateBatchletElement(batchProject, file, cp1, batchlet);
        } else if (chunk != null) {
            this.validateChunkElement(batchProject, file, cp1, chunk);
        }
        Element partition = XMLUtilities.getUniqueChild((Element)step, (String)"partition");
        if (partition != null) {
            this.validatePartitionElement(batchProject, file, cp1, partition);
        }
        if ((listeners = XMLUtilities.getUniqueChild((Element)step, (String)"listeners")) != null) {
            Element[] elementArray = XMLUtilities.getChildren((Element)listeners, (String)"listener");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element listener = elementArray[n2];
                String ref = listener.getAttribute("ref");
                if (ref != null && ref.trim().length() > 0) {
                    Collection<IBatchArtifact> as = batchProject.getArtifacts(ref.trim());
                    if (as.isEmpty()) {
                        this.addProblem(BatchValidationMessages.STEP_LISTENER_IS_NOT_FOUND, BatchSeverityPreferences.UNKNOWN_ARTIFACT_NAME, listener, "ref", file, -1);
                    } else {
                        boolean isCorrectType;
                        IBatchArtifact a = as.iterator().next();
                        boolean bl = isCorrectType = chunk != null ? a.getArtifactType().getTag().equals("step") : a.getArtifactType().equals(BatchArtifactType.STEP_LISTENER);
                        if (!isCorrectType) {
                            this.addProblem(BatchValidationMessages.STEP_LISTENER_IS_EXPECTED, BatchSeverityPreferences.WRONG_ARTIFACT_TYPE, listener, "ref", file, -1);
                        }
                        this.validateProperties(batchProject, file, cp1, listener, a);
                    }
                }
                ++n2;
            }
        }
        cp1.complete(null);
    }

    private void validatePartitionElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element partition) {
        this.validateChildRefAndProperties(batchProject, file, cp, partition, BatchArtifactType.PARTITION_MAPPER, BatchValidationMessages.MAPPER_IS_NOT_FOUND, BatchValidationMessages.MAPPER_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, partition, BatchArtifactType.PARTITION_ANALYZER, BatchValidationMessages.ANALYZER_IS_NOT_FOUND, BatchValidationMessages.ANALYZER_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, partition, BatchArtifactType.PARTITION_COLLECTOR, BatchValidationMessages.COLLECTOR_IS_NOT_FOUND, BatchValidationMessages.COLLECTOR_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, partition, BatchArtifactType.PARTITION_REDUCER, BatchValidationMessages.REDUCER_IS_NOT_FOUND, BatchValidationMessages.REDUCER_IS_EXPECTED);
    }

    private void validateDecisionElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element decision) {
        this.validateRefAndProperties(batchProject, file, cp, decision, BatchArtifactType.DECIDER, BatchValidationMessages.DECIDER_IS_NOT_FOUND, BatchValidationMessages.DECIDER_IS_EXPECTED);
    }

    private void validateBatchletElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element batchlet) {
        this.validateRefAndProperties(batchProject, file, cp, batchlet, BatchArtifactType.BATCHLET, BatchValidationMessages.BATCHLET_IS_NOT_FOUND, BatchValidationMessages.BATCHLET_IS_EXPECTED);
    }

    private void validateChunkElement(IBatchProject batchProject, IFile file, ContextProperties cp, Element chunk) {
        this.validateChildRefAndProperties(batchProject, file, cp, chunk, BatchArtifactType.ITEM_READER, BatchValidationMessages.READER_IS_NOT_FOUND, BatchValidationMessages.READER_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, chunk, BatchArtifactType.ITEM_WRITER, BatchValidationMessages.WRITER_IS_NOT_FOUND, BatchValidationMessages.WRITER_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, chunk, BatchArtifactType.ITEM_PROCESSOR, BatchValidationMessages.PROCESSOR_IS_NOT_FOUND, BatchValidationMessages.PROCESSOR_IS_EXPECTED);
        this.validateChildRefAndProperties(batchProject, file, cp, chunk, BatchArtifactType.CHECKPOINT_ALGORITHM, BatchValidationMessages.CHECKPOINT_ALGORITHM_IS_NOT_FOUND, BatchValidationMessages.CHECKPOINT_ALGORITHM_IS_EXPECTED);
        this.validateExceptions(batchProject, file, chunk, "skippable-exception-classes");
        this.validateExceptions(batchProject, file, chunk, "retryable-exception-classes");
        this.validateExceptions(batchProject, file, chunk, "no-rollback-exception-classes");
    }

    private void validateChildRefAndProperties(IBatchProject batchProject, IFile file, ContextProperties cp, Element element, BatchArtifactType type, String notFoundMessage, String wrongTypeMessage) {
        Element child = XMLUtilities.getUniqueChild((Element)element, (String)type.getTag());
        if (child != null) {
            this.validateRefAndProperties(batchProject, file, cp, child, type, notFoundMessage, wrongTypeMessage);
        }
    }

    private void validateRefAndProperties(IBatchProject batchProject, IFile file, ContextProperties cp, Element element, BatchArtifactType type, String notFoundMessage, String wrongTypeMessage) {
        String ref = element.getAttribute("ref");
        if (ref != null && ref.trim().length() > 0) {
            Collection<IBatchArtifact> as = batchProject.getArtifacts(ref.trim());
            if (as.isEmpty()) {
                this.addProblem(notFoundMessage, BatchSeverityPreferences.UNKNOWN_ARTIFACT_NAME, element, "ref", file, -1);
            } else {
                IBatchArtifact a = as.iterator().next();
                if (!a.getArtifactType().equals(type)) {
                    this.addProblem(wrongTypeMessage, BatchSeverityPreferences.WRONG_ARTIFACT_TYPE, element, "ref", file, -1);
                }
                this.validateProperties(batchProject, file, cp, element, a);
                if (!this.isAsYouTypeValidation()) {
                    this.getValidationContext().addLinkedCoreResource(SHORT_ID, a.getType().getResource().getFullPath().toString(), file.getFullPath(), true);
                }
            }
            if (!this.isAsYouTypeValidation()) {
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, ref, file.getFullPath(), true);
            }
        }
    }

    private void validateProperties(IBatchProject batchProject, IFile file, ContextProperties cp, Element parent, IBatchArtifact a) {
        new ContextProperties(cp, parent, file).complete(a);
    }

    public boolean isEnabled(IProject project) {
        return BatchSeverityPreferences.isValidationEnabled(project);
    }

    private void validateExceptions(IBatchProject batchProject, IFile file, Element element, String tagName) {
        Element child = XMLUtilities.getUniqueChild((Element)element, (String)tagName);
        if (child != null) {
            String[] stringArray = new String[]{"include", "exclude"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element[] es;
                String tagName1 = stringArray[n2];
                Element[] elementArray = es = XMLUtilities.getChildren((Element)child, (String)tagName1);
                int n3 = es.length;
                int n4 = 0;
                while (n4 < n3) {
                    Element e = elementArray[n4];
                    String className = e.getAttribute("class").trim();
                    IType type = ((BatchProject)batchProject).getType(className);
                    if (type == null) {
                        this.addProblem(BatchValidationMessages.EXCEPTION_CLASS_IS_NOT_FOUND, BatchSeverityPreferences.UNKNOWN_EXCEPTION_CLASS, e, "class", file, -1);
                    } else {
                        ParametedType pt = ((BatchProject)batchProject).getTypeFactory().newParametedType(type);
                        boolean isException = false;
                        while (pt != null && !(isException = "java.lang.Exception".equals(pt.getType().getFullyQualifiedName()))) {
                            pt = pt.getSuperType();
                        }
                        if (!isException) {
                            this.addProblem(BatchValidationMessages.EXCEPTION_CLASS_DOES_NOT_EXTEND_JAVA_LANG_EXCEPTION, BatchSeverityPreferences.WRONG_EXCEPTION_CLASS, e, "class", file, -1);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private Set<IFile> collectFiles(IProject project, Set<IFile> changedFiles, IProjectValidationContext context) {
        HashSet<IFile> files = new HashSet<IFile>();
        if (context == null) {
            files.addAll(changedFiles);
            return files;
        }
        BatchProject batchProject = BatchProjectFactory.getBatchProject(project, true);
        HashSet<IFile> direct = new HashSet<IFile>();
        HashSet<IFile> dependent = new HashSet<IFile>();
        for (IFile f : changedFiles) {
            Set paths;
            block16: {
                if (f == null || !f.exists() || f.getProject() != project) continue;
                paths = context.getCoreResourcesByVariableName(SHORT_ID, f.getFullPath().toOSString(), true);
                String name = f.getName();
                if (name.toLowerCase().endsWith(".java")) {
                    try {
                        IType[] ts;
                        ICompilationUnit unit = EclipseUtil.getCompilationUnit((IFile)f);
                        if (unit == null) break block16;
                        IType[] iTypeArray = ts = unit.getTypes();
                        int n = ts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType t = iTypeArray[n2];
                            String type = t.getFullyQualifiedName();
                            Set paths1 = context.getCoreResourcesByVariableName(SHORT_ID, type, true);
                            if (paths1 != null) {
                                if (paths != null) {
                                    paths.addAll(paths1);
                                } else {
                                    paths = paths1;
                                }
                            }
                            ++n2;
                        }
                        Collection<IBatchArtifact> as = batchProject.getArtifacts((IResource)f);
                        if (!as.isEmpty()) {
                            for (IBatchArtifact a : as) {
                                String n3 = a.getName();
                                Set paths1 = context.getCoreResourcesByVariableName(SHORT_ID, n3, true);
                                if (paths1 == null) continue;
                                if (paths != null) {
                                    paths.addAll(paths1);
                                    continue;
                                }
                                paths = paths1;
                            }
                        }
                    }
                    catch (CoreException e) {
                        BatchCorePlugin.pluginLog().logError((Throwable)e);
                    }
                } else if (name.toLowerCase().endsWith(".xml")) {
                    if (!direct.contains(f) && !dependent.contains(f)) {
                        files.add(f);
                    }
                    direct.add(f);
                    dependent.remove(f);
                }
            }
            if (paths == null) continue;
            for (IPath path : paths) {
                IFile f1 = project.getParent().getFile(path);
                if (!f1.exists() || direct.contains(f1) || dependent.contains(f1)) continue;
                dependent.add(f1);
                files.add(f1);
            }
        }
        return files;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new BatchPreferenceInfo());
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    class BatchPreferenceInfo
    implements IPreferenceInfo {
        BatchPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return BatchValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return BatchValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return BatchCorePlugin.PLUGIN_ID;
        }
    }

    class ContextProperties
    implements BatchConstants {
        ContextProperties parent;
        Map<String, SimpleReference> declared = new HashMap<String, SimpleReference>();
        Set<String> referenced = new HashSet<String>();

        public ContextProperties(ContextProperties parent, Element element, IFile file) {
            this.parent = parent;
            Element properties = XMLUtilities.getUniqueChild((Element)element, (String)"properties");
            if (properties != null) {
                Element property;
                Element[] es;
                Element[] elementArray = es = XMLUtilities.getChildren((Element)properties, (String)"property");
                int n = es.length;
                int n2 = 0;
                while (n2 < n) {
                    property = elementArray[n2];
                    String name = property.getAttribute("name").trim();
                    this.declared.put(name, new SimpleReference(property, "name", file));
                    ++n2;
                }
                elementArray = es;
                n = es.length;
                n2 = 0;
                while (n2 < n) {
                    property = elementArray[n2];
                    this.lookForPropertyReferences(property, file);
                    ++n2;
                }
            }
        }

        void lookForPropertyReferences(Element e, IFile file) {
            NamedNodeMap as = e.getAttributes();
            int k = 0;
            while (k < as.getLength()) {
                String value;
                Node n = as.item(k);
                if (n instanceof Attr && (value = ((Attr)n).getValue()).trim().length() > 0) {
                    SimpleReference v = new SimpleReference(e, n.getNodeName(), file);
                    int i = 0;
                    while (i < value.length()) {
                        int i2;
                        int i1 = value.indexOf(JOB_PROPERTY_CALL_START, i);
                        if (i1 < 0 || (i2 = value.indexOf(JOB_PROPERTY_CALL_END, i1 += JOB_PROPERTY_CALL_START.length())) < 0) break;
                        String name = value.substring(i1, i2);
                        if (!this.requestProperty(name)) {
                            SimpleReference v1 = new SimpleReference(v.start + i1 + 1, name.length(), file);
                            BatchValidator.this.addProblem(BatchValidationMessages.UNKNOWN_PROPERTY, BatchSeverityPreferences.UNKNOWN_PROPERTY, new String[]{name}, v1.getLength(), v1.getStartPosition(), (IResource)file);
                        }
                        i = i2;
                    }
                }
                ++k;
            }
        }

        boolean requestProperty(String name) {
            if (this.declared.containsKey(name)) {
                this.referenced.add(name);
                return true;
            }
            return this.parent != null && this.parent.requestProperty(name);
        }

        public void complete(IBatchArtifact a) {
            for (String name : this.declared.keySet()) {
                if (this.referenced.contains(name) || a != null && a.getProperty(name) != null) continue;
                SimpleReference ref = this.declared.get(name);
                if (a == null) {
                    BatchValidator.this.addProblem(BatchValidationMessages.PROPERTY_IS_NOT_USED_1, BatchSeverityPreferences.UNUSED_PROPERTY, new String[]{name}, ref.getLength(), ref.getStartPosition(), (IResource)ref.getResource());
                    continue;
                }
                BatchValidator.this.addProblem(BatchValidationMessages.PROPERTY_IS_NOT_USED, BatchSeverityPreferences.UNUSED_PROPERTY, new String[]{name, a.getName()}, ref.getLength(), ref.getStartPosition(), (IResource)ref.getResource());
            }
        }
    }
}

