/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.scanner.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.internal.core.scanner.BatchArchiveDetector;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.util.UniquePaths;

public class Libs
implements IElementChangedListener {
    protected IProject object;
    protected List<String> paths = null;
    Map<IPath, String> paths2 = new HashMap<IPath, String>();
    Set<String> projects = new HashSet<String>();
    int excudedState = 0;
    List<LibsListener> listeners = new ArrayList<LibsListener>();
    boolean isActive = false;
    int classpathVersion = 0;
    int pathsVersion = -1;
    static String[] SYSTEM_JARS = new String[]{"rt.jar", "jsse.jar", "jce.jar", "charsets.jar"};
    public static Set<String> SYSTEM_JAR_SET = new HashSet<String>();

    static {
        int i = 0;
        while (i < SYSTEM_JARS.length) {
            SYSTEM_JAR_SET.add(SYSTEM_JARS[i]);
            ++i;
        }
    }

    public Libs(IProject object) {
        this.object = object;
    }

    public void init() {
        if (!this.isActive) {
            this.isActive = true;
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }
    }

    public void destroy() {
        if (this.isActive) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.isActive = false;
        }
    }

    private IProject getProjectResource() {
        return this.object;
    }

    public IPackageFragmentRoot getLibrary(String path) {
        return BatchArchiveDetector.findPackageFragmentRoot(path, this.object);
    }

    public IPackageFragmentRoot getLibrary(File f) {
        IPackageFragmentRoot result = null;
        if (f.exists()) {
            String path = "";
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException iOException) {
                path = f.getAbsolutePath().replace('\\', '/');
            }
            result = this.getLibrary(path);
        }
        return result;
    }

    public boolean update() {
        boolean result = false;
        int cpv = this.classpathVersion;
        if (this.hasToUpdatePaths()) {
            result = this.updatePaths(this.getNewPaths(), cpv);
            if (this.isExcludedStateChanged()) {
                result = true;
            }
            if (this.paths == null && result) {
                this.fire();
                return true;
            }
        }
        if (result) {
            this.fire();
        }
        return result;
    }

    public void requestForUpdate() {
        ++this.classpathVersion;
    }

    synchronized boolean hasToUpdatePaths() {
        return this.classpathVersion > this.pathsVersion;
    }

    private List<String> getNewPaths() {
        List<String> result = null;
        try {
            result = Libs.getAllVisibleLibraries(this.getProjectResource());
            List<String> jre = Libs.getJREClassPath(this.getProjectResource());
            if (jre != null) {
                result.removeAll(jre);
            }
            if (result != null) {
                Iterator<String> it = result.iterator();
                while (it.hasNext()) {
                    String path = it.next();
                    String fileName = new File(path).getName();
                    if (!Libs.isJar(path) || !SYSTEM_JAR_SET.contains(fileName)) continue;
                    it.remove();
                }
            }
            this.updateProjects();
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
        return result;
    }

    private void updateProjects() throws JavaModelException {
        HashSet<String> result = new HashSet<String>();
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)this.getProjectResource());
        if (javaProject != null) {
            result.add(this.getProjectResource().getName());
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible()) {
                    result.add(p.getName());
                }
                ++i;
            }
        }
        this.projects = result;
    }

    private boolean isExcludedStateChanged() {
        try {
            int es = this.computeExcludedState();
            if (es != this.excudedState) {
                this.excudedState = es;
                return true;
            }
        }
        catch (JavaModelException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
        return false;
    }

    private int computeExcludedState() throws JavaModelException {
        int result = 0;
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)this.getProjectResource());
        if (javaProject != null) {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IPath p = es[i].getPath();
                IPath[] ps = es[i].getExclusionPatterns();
                if (ps != null && ps.length > 0) {
                    int j = 0;
                    while (j < ps.length) {
                        String key = String.valueOf(p.toString()) + "/" + ps[j].toString();
                        result += key.hashCode();
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private synchronized boolean updatePaths(List<String> newPaths, int cpv) {
        if (cpv <= this.pathsVersion) {
            return false;
        }
        this.pathsVersion = cpv;
        if (this.paths == null && newPaths == null) {
            return false;
        }
        if (newPaths != null && this.paths != null && this.paths.size() == newPaths.size()) {
            boolean b = false;
            int i = 0;
            while (i < this.paths.size() && !b) {
                if (!this.paths.get(i).equals(newPaths.get(i))) {
                    b = true;
                }
                ++i;
            }
            if (!b) {
                return false;
            }
        }
        this.paths = newPaths;
        this.createMap();
        return true;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<IPath, String> getPathsAsMap() {
        return this.paths2;
    }

    private void createMap() {
        this.paths2.clear();
        if (this.paths != null) {
            for (String p : this.paths) {
                this.paths2.put(UniquePaths.getInstance().intern((IPath)new Path(p)), p);
            }
        }
    }

    public synchronized void addListener(LibsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LibsListener listener) {
        this.listeners.remove(listener);
    }

    void fire() {
        LibsListener[] libsListenerArray = this.getListeners();
        int n = libsListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibsListener listener = libsListenerArray[n2];
            listener.pathsChanged(this.paths);
            ++n2;
        }
    }

    private synchronized LibsListener[] getListeners() {
        return this.listeners.toArray(new LibsListener[0]);
    }

    public void elementChanged(ElementChangedEvent event) {
        IProject project = this.getProjectResource();
        if (project == null || !project.exists()) {
            this.destroy();
            return;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta dc = iJavaElementDeltaArray[n2];
            if (dc.getElement() instanceof IJavaProject && this.isReleventProject(((IJavaProject)dc.getElement()).getProject())) {
                int f = dc.getFlags();
                if ((f & 0x220000) != 0) {
                    this.requestForUpdate();
                    return;
                }
                IJavaElementDelta[] iJavaElementDeltaArray2 = dc.getAffectedChildren();
                int n3 = iJavaElementDeltaArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElementDelta d1 = iJavaElementDeltaArray2[n4];
                    if (d1.getKind() == 1 || d1.getKind() == 2) {
                        this.requestForUpdate();
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean isReleventProject(IProject p) {
        return this.projects.contains(p.getName());
    }

    public void libraryChanged(String jar) {
        LibsListener[] libsListenerArray = this.getListeners();
        int n = libsListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibsListener listener = libsListenerArray[n2];
            listener.libraryChanged(jar);
            ++n2;
        }
    }

    public static List<String> getAllVisibleLibraries(IProject project) {
        return new LibraryCollector((IProject)project).ordered;
    }

    static String expandPath(IPath ipath, IProject project) {
        IResource findMember;
        String s = null;
        String path = ipath.toString();
        if (path.startsWith("/") && path.indexOf("/", 1) > 1 && (findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(ipath)) != null) {
            s = findMember.getLocation().toString();
        }
        if (s == null && path.startsWith("/" + project.getName() + "/") && (findMember = project.findMember(ipath.removeFirstSegments(1))) != null) {
            s = findMember.getLocation().toString();
        }
        if (s == null && new File(path).exists()) {
            s = path;
        }
        try {
            if (s != null) {
                return new File(s).getCanonicalPath();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static List<String> getJREClassPath(IProject project) throws CoreException {
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] es0 = javaProject.getRawClasspath();
        IClasspathEntry[] es = null;
        int i = 0;
        while (i < es0.length && es == null) {
            IClasspathContainer container;
            if (es0[i].getEntryKind() == 5 && es0[i].getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") && (container = JavaCore.getClasspathContainer((IPath)es0[i].getPath(), (IJavaProject)javaProject)) != null) {
                es = container.getClasspathEntries();
            }
            ++i;
        }
        if (es == null) {
            return l;
        }
        i = 0;
        while (i < es.length) {
            try {
                String s = null;
                String path = es[i].getPath().toString();
                if (path.startsWith("/" + project.getName() + "/")) {
                    s = project.findMember(es[i].getPath().removeFirstSegments(1)).getLocation().toString();
                } else if (new File(path).isFile()) {
                    s = path;
                }
                if (s != null) {
                    l.add(new File(s).getCanonicalPath());
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return l;
    }

    public static boolean isJar(String path) {
        return (path = path.toLowerCase()).endsWith(".jar") || path.endsWith(".zip");
    }

    private static class LibraryCollector {
        IProject project;
        List<String> ordered = new ArrayList<String>();
        Set<String> paths = new HashSet<String>();
        Set<IProject> processed = new HashSet<IProject>();

        LibraryCollector(IProject project) {
            this.project = project;
            this.process(project);
        }

        void process(IProject project) {
            if (this.processed.contains(project)) {
                return;
            }
            this.processed.add(project);
            IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                return;
            }
            IClasspathEntry[] es = null;
            try {
                es = javaProject.getResolvedClasspath(true);
            }
            catch (CoreException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
                return;
            }
            int i = 0;
            while (i < es.length) {
                if (project == this.project || es[i].isExported()) {
                    String s;
                    if (es[i].getEntryKind() == 2) {
                        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment());
                        if (p != null && p.isAccessible()) {
                            this.process(p);
                        }
                    } else if (es[i].getEntryKind() == 1 && (s = Libs.expandPath(es[i].getPath(), project)) != null && !this.paths.contains(s)) {
                        this.paths.add(s);
                        this.ordered.add(s);
                    }
                }
                ++i;
            }
        }
    }

    public static interface LibsListener {
        public void pathsChanged(List<String> var1);

        public void libraryChanged(String var1);
    }
}

