/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class ParametedTypeFactory {
    static Map<Character, String> primitives = new HashMap<Character, String>();
    public static String OBJECT;
    Map<String, ParametedType> cache = new Hashtable<String, ParametedType>();

    static {
        primitives.put(Character.valueOf('I'), "Ljava.lang.Integer;");
        primitives.put(Character.valueOf('S'), "Ljava.lang.Short;");
        primitives.put(Character.valueOf('J'), "Ljava.lang.Long;");
        primitives.put(Character.valueOf('C'), "Ljava.lang.Character;");
        primitives.put(Character.valueOf('F'), "Ljava.lang.Float;");
        primitives.put(Character.valueOf('D'), "Ljava.lang.Double;");
        primitives.put(Character.valueOf('Z'), "Ljava.lang.Boolean;");
        primitives.put(Character.valueOf('B'), "Ljava.lang.Boolean;");
        OBJECT = "QObject;";
    }

    public ParametedType newParametedType(IType type) {
        ParametedType parametedType = new ParametedType();
        if (type != null && !type.isBinary()) {
            ISourceRange r = null;
            try {
                r = type.getNameRange();
            }
            catch (CoreException e) {
                CommonCorePlugin.getDefault().logError(e);
            }
            if (r != null) {
                parametedType = new TypeDeclaration(parametedType, type.getResource(), r.getOffset(), r.getLength());
            }
        }
        parametedType.setFactory(this);
        parametedType.setType(type);
        if (type != null) {
            parametedType.setSignature(String.valueOf('L') + type.getFullyQualifiedName() + ';');
        }
        String[] ps = null;
        try {
            ps = type.getTypeParameterSignatures();
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        if (ps != null && ps.length > 0) {
            int i = 0;
            while (i < ps.length) {
                try {
                    ParametedType p = this.getParametedTypeForParameter((IMember)type, ps[i], null);
                    if (p != null) {
                        parametedType.addParameter(p);
                    }
                }
                catch (JavaModelException e) {
                    CommonCorePlugin.getDefault().logError(e);
                }
                ++i;
            }
        }
        return parametedType;
    }

    public ParametedType getParametedType(IMember context, String typeSignature) throws JavaModelException {
        return this.getParametedType(context, null, typeSignature);
    }

    public ParametedType getParametedType(IMember context, IParametedType basetype, String typeSignature) throws JavaModelException {
        char c;
        String key;
        ParametedType param;
        if (typeSignature == null) {
            return null;
        }
        if (basetype != null && (param = ((ParametedType)basetype).findParameter(typeSignature)) != null) {
            return param;
        }
        IType contextType = context instanceof IType ? (IType)context : context.getDeclaringType();
        String string = key = context == null || context.isBinary() || OBJECT.equals(typeSignature) ? typeSignature : String.valueOf(contextType.getFullyQualifiedName()) + "+" + typeSignature;
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        ParametedType result = new ParametedType();
        result.setFactory(this);
        result.setSignature(typeSignature);
        typeSignature = typeSignature.substring(result.getArrayIndex());
        char c2 = c = typeSignature.length() == 0 ? (char)'\u0000' : typeSignature.charAt(0);
        if (primitives.containsKey(Character.valueOf(c)) && typeSignature.length() == 1) {
            typeSignature = primitives.get(Character.valueOf(c));
            result.setSignature(String.valueOf(result.getArrayPrefix()) + typeSignature);
            result.setPrimitive(true);
        } else if (c == '+') {
            typeSignature = typeSignature.substring(1);
            result.setUpper(true);
        } else if (c == '-') {
            typeSignature = typeSignature.substring(1);
            result.setLower(true);
        } else if (c == '*' && typeSignature.length() == 1) {
            result.setUpper(true);
            return result;
        }
        int startToken = typeSignature.indexOf(60);
        if (startToken < 0) {
            ParametedType st;
            int i;
            String[] ps;
            IType type;
            String resovedTypeName = EclipseJavaUtil.resolveTypeAsString(contextType, typeSignature);
            if (resovedTypeName == null) {
                return null;
            }
            if (!context.isBinary() || typeSignature.charAt(0) == 'T') {
                StringBuffer ns = new StringBuffer();
                ns.append(result.getArrayPrefix());
                if (result.isLower()) {
                    ns.append('-');
                }
                if (result.isUpper()) {
                    ns.append('+');
                }
                ns.append('L').append(resovedTypeName).append(';');
                result.setSignature(ns.toString());
            }
            if ((type = EclipseJavaUtil.findType(context.getJavaProject(), resovedTypeName)) != null) {
                result.setType(type);
                this.cache.put(key, result);
                return result;
            }
            if (context instanceof IMethod) {
                ps = ((IMethod)context).getTypeParameterSignatures();
                i = 0;
                while (i < ps.length) {
                    st = this.getParametedTypeForParameter(context, ps[i], result);
                    if (st != null) {
                        if (st.getSignature().indexOf(58) >= 0) {
                            CommonCorePlugin.getDefault().logWarning("Wrong signature=" + st.getSignature());
                        }
                        return st;
                    }
                    ++i;
                }
            }
            ps = contextType.getTypeParameterSignatures();
            i = 0;
            while (i < ps.length) {
                st = this.getParametedTypeForParameter((IMember)contextType, ps[i], result);
                if (st != null) {
                    return st;
                }
                ++i;
            }
        } else {
            int endToken = typeSignature.lastIndexOf(62);
            if (endToken < startToken) {
                return null;
            }
            String typeName = String.valueOf(typeSignature.substring(0, startToken)) + typeSignature.substring(endToken + 1);
            String resovedTypeName = EclipseJavaUtil.resolveTypeAsString(contextType, typeName);
            if (resovedTypeName == null) {
                return null;
            }
            IType type = EclipseJavaUtil.findType(context.getJavaProject(), resovedTypeName);
            if (type != null) {
                result.setType(type);
                this.cache.put(key, result);
                StringBuffer newParams = new StringBuffer();
                String[] paramSignatures = null;
                try {
                    paramSignatures = Signature.getTypeArguments((String)typeSignature);
                }
                catch (IllegalArgumentException e) {
                    CommonCorePlugin.getDefault().logError(e);
                }
                if (paramSignatures != null) {
                    String[] stringArray = paramSignatures;
                    int n = paramSignatures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String paramSignature = stringArray[n2];
                        ParametedType param2 = this.getParametedType(context, basetype, paramSignature);
                        if (param2 == null) {
                            param2 = new ParametedType();
                            param2.setSignature(paramSignature);
                        }
                        result.addParameter(param2);
                        newParams.append(param2.getSignature());
                        ++n2;
                    }
                }
                if (!context.isBinary()) {
                    StringBuffer ns = new StringBuffer();
                    ns.append(result.getArrayPrefix());
                    if (result.isLower()) {
                        ns.append('-');
                    }
                    if (result.isUpper()) {
                        ns.append('+');
                    }
                    ns.append('L').append(resovedTypeName).append('<').append(newParams).append('>').append(';');
                    result.setSignature(ns.toString());
                }
                return result;
            }
        }
        return null;
    }

    public ParametedType getParametedTypeForParameter(IMember context, String typeParameterSignature, ParametedType result) throws JavaModelException {
        IType contextType = context instanceof IType ? (IType)context : context.getDeclaringType();
        String key = context == null ? typeParameterSignature : String.valueOf(contextType.getFullyQualifiedName()) + "+" + typeParameterSignature;
        String t = Signature.getTypeVariable((String)typeParameterSignature);
        String[] bounds = Signature.getTypeParameterBounds((String)typeParameterSignature);
        t = String.valueOf('L') + t + ';';
        if (result == null || t.equals(result.getSignature()) || result.getSignature().endsWith("[" + t)) {
            if (bounds.length > 0 && bounds[0].length() > 0) {
                ParametedType st = this.getParametedType((IMember)contextType, bounds[0]);
                if (st != null) {
                    result = new TypeDeclaration(st, context.getResource(), 0, 0);
                    result.setUpper(true);
                }
            } else if (result != null) {
                result.setSignature(t);
            }
            if (result == null) {
                result = new ParametedType();
                result.setFactory(this);
                result.setSignature(t);
            }
            result.setVariable(true);
            this.cache.put(key, result);
            return result;
        }
        return null;
    }

    public void clean() {
        this.cache.clear();
    }
}

