/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.model;

import java.util.List;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.image.XModelObjectImageDescriptor;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;
import org.jboss.tools.jst.web.ui.palette.model.LargeImageDescriptor;
import org.jboss.tools.jst.web.ui.palette.model.PaletteXModelObject;

public class PaletteItem
extends ToolEntry
implements PaletteXModelObject {
    private XModelObject xobject;
    private String description;
    private String startText;
    private String endText;
    private boolean reformat;
    private String keywords = null;

    public PaletteItem(XModelObject xobject) {
        super(null, null, null, null);
        this.setXModelObject(xobject);
    }

    @Override
    public XModelObject getXModelObject() {
        return this.xobject;
    }

    public void setXModelObject(XModelObject xobject) {
        this.xobject = xobject;
        String label = xobject.getModelEntity().getRenderer().getTitle(xobject);
        if (label.indexOf(46) >= 0) {
            label = label.substring(label.indexOf(46) + 1);
        }
        this.setLabel(label);
        XModelObjectImageDescriptor icon = new XModelObjectImageDescriptor(xobject);
        this.setSmallIcon((ImageDescriptor)icon);
        this.setLargeIcon(new LargeImageDescriptor(xobject));
        String description = xobject.getAttributeValue("description");
        this.description = description != null && description.trim().length() > 0 ? description : null;
        this.startText = xobject.getAttributeValue("start text");
        this.endText = xobject.getAttributeValue("end text");
        this.reformat = "yes".equals(xobject.getAttributeValue("automatically reformat tag body"));
    }

    public String getHtmlDescription() {
        return this.description;
    }

    public String getStartText() {
        return this.startText;
    }

    public String getEndText() {
        return this.endText;
    }

    public boolean getReformat() {
        return this.reformat;
    }

    public Tool createTool() {
        return null;
    }

    public String getKeywordsAsString() {
        if (this.keywords == null) {
            List list = PaletteInsertManager.getInstance().getKeyWords(this.xobject.getPath());
            if (list != null) {
                StringBuilder buffer = new StringBuilder();
                for (String word : list) {
                    buffer.append(String.valueOf(word) + " ");
                }
                this.keywords = buffer.toString();
            } else {
                this.keywords = this.getLabel();
            }
        }
        return this.keywords;
    }
}

