/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.kb.taglib.ITagLibRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibVersionRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteSettings;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.AbstractPaletteCategory;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.AbstractPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.AbstractPaletteVersionGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteItemImpl;

public class HTML5DynamicPaletteGroup
extends AbstractPaletteGroup {
    private ArrayList<IPaletteItem> items = new ArrayList();
    private ArrayList<ImageDescriptor> descriptors = new ArrayList();
    private ImageDescriptor imageDescriptor = null;

    public HTML5DynamicPaletteGroup() {
        this.add(new DynamicPaletteVersionGroup());
    }

    public void add(IPaletteItem item) {
        this.items.add(item);
    }

    public void add(ImageDescriptor imageDEscriptor) {
        if (this.descriptors.size() < 3) {
            this.descriptors.add(imageDEscriptor);
        }
    }

    public void initCounts() {
        Collections.sort(this.items, new LastUsedComparator());
        long count = 1L;
        ((PaletteItemImpl)this.items.get(0)).setProjectCountIndex(count);
        int index = this.items.size() - 1;
        while (index >= 0) {
            if (this.items.get(index).getCountIndex() > 0L) {
                this.items.get(index).setCountIndex(count++);
            }
            --index;
        }
        Collections.sort(this.items, new MostPopularComparator());
        long numberOfCalls = 1L;
        int index2 = this.items.size() - 1;
        while (index2 >= 0) {
            if (this.items.get(index2).getNumberOfCalls() > 0L) {
                this.items.get(index2).setNumberOfCalls(numberOfCalls++);
            }
            --index2;
        }
    }

    public List<IPaletteItem> getAllItems() {
        return this.items;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ITagLibRecognizer getRecognizer() {
        return new HTML5DynamicRecognizer();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null && this.descriptors.size() > 0) {
            Image resultImage = new Image((Device)Display.getCurrent(), this.descriptors.size() * 16, 16);
            ImageData data = resultImage.getImageData();
            data.alpha = 0;
            resultImage = new Image((Device)Display.getCurrent(), data);
            GC gc = new GC((Drawable)resultImage);
            int x = 0;
            for (ImageDescriptor descriptor : this.descriptors) {
                if (descriptor == null) continue;
                Image image = descriptor.createImage((Device)Display.getCurrent());
                gc.drawImage(image, x, 0);
                x += image.getBounds().width;
            }
            gc.dispose();
            this.imageDescriptor = ImageDescriptor.createFromImage((Image)resultImage);
        }
        return this.imageDescriptor;
    }

    private String getIdWithoutVersion(IPaletteItem item) {
        return "/" + item.getCategory().getVersionGroup().getGroup().getName() + "/" + item.getName();
    }

    public class DynamicPaletteCategoty
    extends AbstractPaletteCategory {
        @Override
        public List<IPaletteItem> getItems() {
            ArrayList<IPaletteItem> list = new ArrayList<IPaletteItem>();
            ArrayList<String> ids = new ArrayList<String>();
            if (PaletteSettings.TYPE_LAST_USED.equals(PaletteSettings.getInstance().getDynamicGroupType())) {
                Collections.sort(HTML5DynamicPaletteGroup.this.items, new LastUsedComparator());
            } else {
                Collections.sort(HTML5DynamicPaletteGroup.this.items, new MostPopularComparator());
            }
            int index = 0;
            for (IPaletteItem item : HTML5DynamicPaletteGroup.this.items) {
                if (index >= PaletteSettings.getInstance().getDynamicGroupNumber()) break;
                String id = HTML5DynamicPaletteGroup.this.getIdWithoutVersion(item);
                if (ids.contains(id) || item.getCountIndex() <= 0L) continue;
                ids.add(id);
                list.add(item);
                ++index;
            }
            return list;
        }
    }

    public class DynamicPaletteVersionGroup
    extends AbstractPaletteVersionGroup {
        public DynamicPaletteVersionGroup() {
            this.add(new DynamicPaletteCategoty());
        }

        @Override
        public IHTMLLibraryVersion getVersion() {
            return DynamicVersion.DYNAMIC_1_0;
        }
    }

    public static enum DynamicVersion implements IHTMLLibraryVersion
    {
        DYNAMIC_1_0("1.0");

        String version;

        private DynamicVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return this.version;
        }

        public boolean isPreferredJSLib(IFile file, String libName) {
            return false;
        }

        public boolean isReferencingJSLib(IFile file, String libName) {
            return false;
        }
    }

    public class HTML5DynamicRecognizer
    implements ITagLibVersionRecognizer {
        public boolean shouldBeLoaded(ITagLibrary lib, ELContext context) {
            return false;
        }

        public boolean isUsed(ELContext context) {
            return true;
        }

        public boolean isUsed(IFile file) {
            return true;
        }

        public IHTMLLibraryVersion getVersion(ELContext context) {
            return DynamicVersion.DYNAMIC_1_0;
        }
    }

    public class LastUsedComparator
    implements Comparator<IPaletteItem> {
        @Override
        public int compare(IPaletteItem i1, IPaletteItem i2) {
            return Long.compare(i2.getCountIndex(), i1.getCountIndex());
        }
    }

    public class MostPopularComparator
    implements Comparator<IPaletteItem> {
        @Override
        public int compare(IPaletteItem i1, IPaletteItem i2) {
            int c = Long.compare(i2.getNumberOfCalls(), i1.getNumberOfCalls());
            if (c == 0) {
                c = Long.compare(i2.getCountIndex(), i1.getCountIndex());
            }
            return c;
        }
    }
}

