/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import java.beans.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.HTMLFieldEditorFactory;

public class NewMeterWizardPage
extends NewHTMLWidgetWizardPage {
    static Double ZERO = 0.0;
    static Double ONE = 1.0;

    public NewMeterWizardPage() {
        super("newMeter", WizardMessages.newMeterWizardTitle);
        this.setDescription(WizardMessages.newMenuitemWizardDescription);
    }

    @Override
    protected void createFieldPanel(Composite parent) {
        this.addEditor(HTMLFieldEditorFactory.createMeterValueEditor(), parent);
        this.addEditor(HTMLFieldEditorFactory.createMeterMinEditor(), parent);
        this.addEditor(HTMLFieldEditorFactory.createMeterMaxEditor(), parent);
        this.createSeparator(parent);
        this.addEditor(HTMLFieldEditorFactory.createMeterLowEditor(), parent);
        this.addEditor(HTMLFieldEditorFactory.createMeterOptimumEditor(), parent);
        this.addEditor(HTMLFieldEditorFactory.createMeterHighEditor(), parent);
        this.createSeparator(parent);
        this.createIDEditor(parent, true);
        this.addEditor(JQueryFieldEditorFactory.createFormReferenceEditor(), parent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    @Override
    public void validate() throws ValidationException {
        Double value = this.readNumber("value");
        if (value == null) {
            throw new ValidationException(WizardMessages.errorMeterValueRequired);
        }
        String[] attrsOrder = new String[]{"min", "low", "optimum", "high", "max"};
        Double[] doubleArray = new Double[5];
        doubleArray[0] = ZERO;
        doubleArray[4] = ONE;
        Double[] defaults = doubleArray;
        int i = 0;
        while (i < attrsOrder.length) {
            int j = i + 1;
            while (j < attrsOrder.length) {
                this.assertOrder(attrsOrder[i], defaults[i], attrsOrder[j], defaults[j]);
                ++j;
            }
            ++i;
        }
        this.assertOrder("min", ZERO, "value", null);
        this.assertOrder("value", null, "max", ONE);
        super.validate();
    }

    Double readNumber(String editorID) throws ValidationException {
        String value = this.getEditorValue(editorID).trim();
        if (value.length() == 0) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(NLS.bind((String)WizardMessages.errorValueNotNumber, (Object)editorID));
        }
    }

    void assertOrder(String lower, Double defaultLower, String upper, Double defaultUpper) throws ValidationException {
        Double upperValue;
        Double lowerValue = this.readNumber(lower);
        if (lowerValue == null) {
            lowerValue = defaultLower;
        }
        if ((upperValue = this.readNumber(upper)) == null) {
            upperValue = defaultUpper;
        }
        if (lowerValue == null || upperValue == null) {
            return;
        }
        if (lowerValue.compareTo(upperValue) > 0) {
            throw new ValidationException(NLS.bind((String)WizardMessages.errorShouldBeLessThan, (Object)lower, (Object)upper), true);
        }
    }

    @Override
    protected int getPreferredBrowser() {
        return 65536;
    }
}

