/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.internal.IListFigure;
import org.jboss.tools.jst.web.ui.palette.internal.ListPopUp;

public abstract class ListFigure
extends Clickable
implements IListFigure {
    private Color backColor = Display.getDefault().getSystemColor(1);
    private Color foreColor = Display.getDefault().getSystemColor(15);
    private ListPopUp popup;

    public ListFigure(String defaultText, final Control control) {
        super((IFigure)new Label(defaultText, JSTWebUIImages.getImage((ImageDescriptor)JSTWebUIImages.getInstance().createImageDescriptor(JSTWebUIImages.DROP_DOWN_LIST_IMAGE))));
        this.getLabel().setTextPlacement(8);
        this.setRolloverEnabled(true);
        this.setBorder((Border)new MarginBorder(2));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ListFigure.this.popup = new ListPopUp(control, ListFigure.this);
                ListFigure.this.popup.show(ListFigure.this.getValues());
            }
        });
    }

    protected Label getLabel() {
        return (Label)this.getChildren().get(0);
    }

    @Override
    public String getSelected() {
        return this.getLabel().getText();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        ButtonModel model = this.getModel();
        if (this.isRolloverEnabled() && model.isMouseOver()) {
            graphics.setBackgroundColor(this.backColor);
            graphics.fillRoundRectangle(this.getClientArea().getCopy().getExpanded(1, 1), 7, 7);
            graphics.setForegroundColor(this.foreColor);
            graphics.drawRoundRectangle(this.getClientArea().getCopy().getExpanded(1, 1), 7, 7);
        }
    }
}

