/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.util.List;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPTagProposalFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropCommand;
import org.jboss.tools.jst.web.ui.palette.CustomPaletteEditPartFactory;
import org.jboss.tools.jst.web.ui.palette.MobilePaletteEditPartFactory;
import org.jboss.tools.jst.web.ui.palette.PaletteDragSourceListener;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteItemDragSourceListener;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteItemTransfer;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteTool;
import org.jboss.tools.jst.web.ui.palette.model.IPaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteItem;

public class PaletteViewer
extends org.eclipse.gef.ui.palette.PaletteViewer {
    private IPalettePageAdapter viewPart;
    DragSourceListener listener;
    private IPaletteModel model;
    static Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance(), ModelTransfer.getInstance()};
    static Transfer[] html5TransferTypes = new Transfer[]{PaletteItemTransfer.getInstance()};

    public PaletteViewer(IPalettePageAdapter viewPart, IPaletteModel model) {
        this.viewPart = viewPart;
        this.model = model;
        if (model.getType().equals(IPaletteModel.TYPE_HTML5)) {
            this.setEditPartFactory((EditPartFactory)new MobilePaletteEditPartFactory());
        } else {
            this.setEditPartFactory((EditPartFactory)new CustomPaletteEditPartFactory());
        }
    }

    void addDragStartSupport() {
        DragSource dragSource = new DragSource(this.getControl(), 3);
        if (this.model.getType().equals(IPaletteModel.TYPE_HTML5)) {
            dragSource.setTransfer(html5TransferTypes);
            this.listener = new PaletteItemDragSourceListener((EditPartViewer)this);
        } else {
            dragSource.setTransfer(transferTypes);
            this.listener = new PaletteDragSourceListener((EditPartViewer)this);
        }
        dragSource.addDragListener(this.listener);
    }

    private boolean isDragging() {
        if (this.listener instanceof PaletteItemDragSourceListener) {
            return ((PaletteItemDragSourceListener)this.listener).isDragging();
        }
        if (this.listener instanceof PaletteDragSourceListener) {
            return ((PaletteDragSourceListener)this.listener).isDragging();
        }
        return false;
    }

    public void setActiveTool(ToolEntry tool) {
        IFigure fig;
        EditPart part = this.getFocusEditPart();
        if (part instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)part).getFigure()) instanceof Clickable) {
            part.setSelected(0);
            ((Clickable)fig).getModel().setArmed(false);
            ((Clickable)fig).getModel().setPressed(false);
            ((Clickable)fig).getModel().setSelected(false);
        }
        super.setActiveTool(null);
        if (!this.isDragging()) {
            if (tool instanceof PaletteItem) {
                this.insertIntoEditor((PaletteItem)tool);
            } else if (tool instanceof PaletteTool) {
                this.insertIntoEditor((PaletteTool)tool);
            }
        }
    }

    private void insertIntoEditor(PaletteTool tool) {
        IPaletteItem item = tool.getPaletteItem();
        ITextEditor editor = this.viewPart.getActiveTextEditor();
        if (editor instanceof JSPMultiPageEditor) {
            DropData dropData = new DropData("palette/item", "", editor.getEditorInput(), (ISourceViewer)((JSPMultiPageEditor)editor).getJspEditor().getTextViewer(), editor.getSelectionProvider());
            PaletteItemDropCommand command = new PaletteItemDropCommand(item, false);
            command.setTagProposalFactory(JSPTagProposalFactory.getInstance());
            command.execute(dropData);
        }
    }

    private void insertIntoEditor(PaletteItem item) {
        this.viewPart.insertIntoEditor(item.getXModelObject());
    }

    public void setEnabled(boolean enabled) {
        EditPart root = this.getContents();
        List v = root.getChildren();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                this.setCategoryEnabled((EditPart)v.get(i), enabled);
                ++i;
            }
        }
    }

    private void setCategoryEnabled(EditPart part, boolean enabled) {
        List v = part.getChildren();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                IFigure fig;
                Object obj = v.get(i);
                if (obj instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)obj).getFigure()) instanceof Clickable) {
                    ((Clickable)fig).setEnabled(enabled);
                }
                ++i;
            }
        }
    }
}

