/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreeViewer;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class WebProjectsTreeListener
extends TreeViewerModelListenerImpl {
    static String[][] LISTENERS = new String[][]{{"org.jboss.tools.jsf.jsfnature", "org.jboss.tools.jsf.ui.navigator.JsfProjectsTreeListener", "org.jboss.tools.jsf.ui"}};
    Map<String, TreeViewerModelListenerImpl> listeners = new HashMap<String, TreeViewerModelListenerImpl>();

    public WebProjectsTreeListener() {
        int i = 0;
        while (i < LISTENERS.length) {
            String nature = LISTENERS[i][0];
            String classname = LISTENERS[i][1];
            String plugin = LISTENERS[i][2];
            if (Platform.getBundle((String)plugin) != null) {
                try {
                    TreeViewerModelListenerImpl impl = (TreeViewerModelListenerImpl)ModelFeatureFactory.getInstance().createFeatureInstance(classname);
                    if (impl != null) {
                        this.listeners.put(nature, impl);
                    }
                }
                catch (ClassCastException e) {
                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    public void setViewer(TreeViewer viewer) {
        super.setViewer(viewer);
        TreeViewerModelListenerImpl[] impls = this.listeners.values().toArray(new TreeViewerModelListenerImpl[0]);
        int i = 0;
        while (i < impls.length) {
            impls[i].setViewer(viewer);
            ++i;
        }
    }

    private TreeViewerModelListenerImpl getListenerImpl(XModelTreeEvent event) {
        String nature = event.getModelObject().getModel().getProperties().getProperty("nature");
        return nature == null ? null : this.listeners.get(nature);
    }

    public void nodeChanged(XModelTreeEvent event) {
        TreeViewerModelListenerImpl impl = this.getListenerImpl(event);
        if (impl != null) {
            impl.nodeChanged(event);
        }
    }

    public void structureChanged(XModelTreeEvent event) {
        TreeViewerModelListenerImpl impl = this.getListenerImpl(event);
        if (impl != null) {
            impl.structureChanged(event);
        }
    }
}

