/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.jst.web.ui.internal.properties.IEditedDescriptor;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModel;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModelListener;

public abstract class AbstractPropertySetViewer
implements IPropertySetViewer {
    protected String category = null;
    protected IPropertySheetModel model;
    protected IEditedDescriptor editedDescriptor;
    protected IPropertySheetModelListener entryListener;

    public AbstractPropertySetViewer() {
        this.createEntryListener();
    }

    @Override
    public IPropertySheetModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(IPropertySheetModel model) {
        if (this.model != null && this.entryListener != null) {
            this.model.removeListener(this.entryListener);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addListener(this.entryListener);
        }
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getCategoryDisplayName() {
        return this.category;
    }

    @Override
    public void setEditedDescriptorService(IEditedDescriptor editedDescriptor) {
        this.editedDescriptor = editedDescriptor;
    }

    protected boolean isPropertySet(IPropertyDescriptor d) {
        IPropertySource s = this.model.getPropertySource();
        return s != null && s.isPropertySet(d.getId());
    }

    protected void createEntryListener() {
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void dispose() {
        this.model.removeListener(this.entryListener);
    }

    @Override
    public void applyEditorValue() {
    }
}

