/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class JSLibXMLLoader {
    static String TAG_LIBS = "libs";
    static String TAG_LIB = "lib";
    static String TAG_VERSION = "version";
    static String ATTR_NAME = "name";
    static String TAG_URL = "url";

    private JSLibXMLLoader() {
    }

    public static JSLibModel load(String s) {
        StringReader reader = new StringReader(s);
        Element root = XMLUtilities.getElement((Reader)reader, (EntityResolver)XMLUtilities.EMPTY_RESOLVER);
        return root != null ? JSLibXMLLoader.load(root) : null;
    }

    public static JSLibModel load(Element root) {
        Element[] libElements;
        JSLibModel result = new JSLibModel();
        Element[] elementArray = libElements = XMLUtilities.getChildren((Element)root, (String)TAG_LIB);
        int n = libElements.length;
        int n2 = 0;
        while (n2 < n) {
            Element[] versionElements;
            Element libElement = elementArray[n2];
            JSLib lib = result.getOrCreateLib(libElement.getAttribute(ATTR_NAME));
            Element[] elementArray2 = versionElements = XMLUtilities.getChildren((Element)libElement, (String)TAG_VERSION);
            int n3 = versionElements.length;
            int n4 = 0;
            while (n4 < n3) {
                Element[] urlElements;
                Element versionElement = elementArray2[n4];
                JSLibVersion version = lib.getOrCreateVersion(versionElement.getAttribute(ATTR_NAME));
                Element[] elementArray3 = urlElements = XMLUtilities.getChildren((Element)versionElement, (String)TAG_URL);
                int n5 = urlElements.length;
                int n6 = 0;
                while (n6 < n5) {
                    Element urlElement = elementArray3[n6];
                    version.getURLs().add(XMLUtilities.getCDATA((Element)urlElement, (boolean)true));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public static String saveToString(JSLibModel model) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            XMLUtilities.serialize((Element)JSLibXMLLoader.save(model), (OutputStream)b);
        }
        catch (IOException iOException) {}
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element save(JSLibModel model) {
        JSLibModel jSLibModel = model;
        synchronized (jSLibModel) {
            Element libsElement = XMLUtilities.createDocumentElement((String)TAG_LIBS);
            JSLib[] jSLibArray = model.getSortedLibs();
            int n = jSLibArray.length;
            int n2 = 0;
            while (n2 < n) {
                JSLib lib = jSLibArray[n2];
                Element libElement = XMLUtilities.createElement((Element)libsElement, (String)TAG_LIB);
                libElement.setAttribute(ATTR_NAME, lib.getName());
                JSLibVersion[] jSLibVersionArray = lib.getSortedVersions();
                int n3 = jSLibVersionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JSLibVersion version = jSLibVersionArray[n4];
                    Element versionElement = XMLUtilities.createElement((Element)libElement, (String)TAG_VERSION);
                    versionElement.setAttribute(ATTR_NAME, version.getVersion());
                    String[] stringArray = version.getSortedUrls();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String url = stringArray[n6];
                        Element urlElement = XMLUtilities.createElement((Element)versionElement, (String)TAG_URL);
                        XMLUtilities.setText((Element)urlElement, (String)url);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            return libsElement;
        }
    }
}

