/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.ui.internal.preferences.Messages;

public class ELSearchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    IFieldEditor timeLimit;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.timeLimit = SwtFieldEditorFactory.INSTANCE.createTextEditor("timeLimit", Messages.ELSearchPreferencePage_searchTimeLimit, this.getPreferenceStore().getString("org.jboss.tools.jst.web.kb.preferences.elSearchTimeLimit"));
        this.timeLimit.doFillIntoGrid((Object)composite);
        this.timeLimit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ELSearchPreferencePage.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected void validate() {
        if (this.timeLimit == null) {
            return;
        }
        String error = null;
        String value = this.timeLimit.getValueAsString();
        try {
            int v = Integer.parseInt(value);
            if (v < 0) {
                error = Messages.ELSearchPreferencePage_searchTimeLimit_invalid;
            }
        }
        catch (NumberFormatException numberFormatException) {
            error = Messages.ELSearchPreferencePage_searchTimeLimit_invalid;
        }
        this.setErrorMessage(error);
        this.setValid(error == null);
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String defaultValue = store.getDefaultString("org.jboss.tools.jst.web.kb.preferences.elSearchTimeLimit");
        this.timeLimit.setValue((Object)defaultValue);
        store.setValue("org.jboss.tools.jst.web.kb.preferences.elSearchTimeLimit", defaultValue);
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
            }
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (!this.isValid()) {
            return false;
        }
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.jboss.tools.jst.web.kb.preferences.elSearchTimeLimit", this.timeLimit.getValueAsString());
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
            }
        }
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WebKbPlugin.getDefault().getPreferenceStore();
    }
}

