/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences;

import java.util.ResourceBundle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;
import org.jboss.tools.jst.web.project.version.ProjectVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.Messages;

public class AbstractImplementationsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String BUNDLE_NAME = "preferences";
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(String.valueOf(AbstractImplementationsPreferencesPage.class.getPackage().getName()) + "." + "preferences");
    private AbstractWebProjectTemplate helper;
    private String[] implementations;
    private String[] templates;
    private String[] libraries;
    private String errorMessage;
    private Label errorMessageLabel;
    private Button addButtonImpl;
    private Button removeButtonImpl;
    private Button addButtonLibraries;
    private Button removeButtonLibraries;
    private Button addButtonProject;
    private Button editButtonProject;
    private Button upButtonProject;
    private Button downButtonProject;
    private Button removeButtonProject;
    private int widthHint;
    private int heightHint;
    private List listImplementations;
    private List listProject;

    public AbstractImplementationsPreferencesPage() {
    }

    public AbstractImplementationsPreferencesPage(String title) {
        super(title);
    }

    public AbstractImplementationsPreferencesPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected AbstractWebProjectTemplate createHelper() {
        return null;
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.heightHint = this.convertVerticalDLUsToPixels(14);
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        root.setLayout((Layout)layout);
        this.errorMessageLabel = new Label(root, 0);
        if (this.errorMessage != null) {
            this.errorMessageLabel.setText(this.errorMessage);
            this.errorMessageLabel.setForeground(Display.getCurrent().getSystemColor(3));
        }
        Composite impl = new Composite(root, 0);
        GridLayout layoutImpl = new GridLayout();
        layoutImpl.numColumns = 2;
        impl.setLayout((Layout)layoutImpl);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        impl.setLayoutData((Object)data);
        this.listImplementations = new List(impl, 2564);
        if (this.errorMessage == null) {
            this.listImplementations.setItems(this.implementations);
        }
        GridData gridDataList = new GridData(1808);
        gridDataList.widthHint = 270;
        gridDataList.horizontalSpan = 1;
        gridDataList.verticalSpan = 2;
        this.listImplementations.setLayoutData((Object)gridDataList);
        this.heightHint = this.convertVerticalDLUsToPixels(14);
        this.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.addButtonImpl = this.createButton(impl, Messages.ImplementationsPreferencesPage_Add);
        if (this.errorMessage != null) {
            this.addButtonImpl.setEnabled(false);
        }
        this.removeButtonImpl = this.createButton(impl, Messages.ImplementationsPreferencesPage_Remove);
        this.removeButtonImpl.setEnabled(false);
        TabFolder tabbedComposite = new TabFolder(root, 0);
        GridData gridDataTab = new GridData(1808);
        tabbedComposite.setLayoutData((Object)gridDataTab);
        TabItem librariesTab = new TabItem(tabbedComposite, 0);
        librariesTab.setText(Messages.ImplementationsPreferencesPage_Library_Sets);
        TabItem projectTab = new TabItem(tabbedComposite, 0);
        projectTab.setText(Messages.ImplementationsPreferencesPage_Project_Templates);
        Composite entryLibraries = new Composite((Composite)tabbedComposite, 0);
        GridLayout layoutEntryLibraries = new GridLayout();
        layoutEntryLibraries.numColumns = 2;
        entryLibraries.setLayout((Layout)layoutEntryLibraries);
        final List listLibraries = new List(entryLibraries, 2564);
        GridData gridDataListLibraries = new GridData(1808);
        gridDataListLibraries.verticalSpan = 2;
        listLibraries.setLayoutData((Object)gridDataListLibraries);
        this.addButtonLibraries = this.createButton(entryLibraries, Messages.ImplementationsPreferencesPage_Add);
        this.addButtonLibraries.setEnabled(false);
        this.removeButtonLibraries = this.createButton(entryLibraries, Messages.ImplementationsPreferencesPage_Remove);
        this.removeButtonLibraries.setEnabled(false);
        librariesTab.setControl((Control)entryLibraries);
        Composite entryProject = new Composite((Composite)tabbedComposite, 0);
        GridLayout layoutEntryProject = new GridLayout();
        layoutEntryProject.numColumns = 2;
        entryProject.setLayout((Layout)layoutEntryProject);
        this.listProject = new List(entryProject, 2564);
        GridData gridDataListProject = new GridData(1808);
        gridDataListProject.verticalSpan = 5;
        this.listProject.setLayoutData((Object)gridDataListProject);
        this.addButtonProject = this.createButton(entryProject, Messages.ImplementationsPreferencesPage_Add);
        this.addButtonProject.setEnabled(false);
        this.editButtonProject = this.createButton(entryProject, Messages.ImplementationsPreferencesPage_Edit);
        this.editButtonProject.setEnabled(false);
        this.upButtonProject = this.createButton(entryProject, Messages.ImplementationsPreferencesPage_Up);
        this.upButtonProject.setEnabled(false);
        GridData d = (GridData)this.upButtonProject.getLayoutData();
        d.verticalIndent = 5;
        this.downButtonProject = this.createButton(entryProject, Messages.ImplementationsPreferencesPage_Down);
        this.downButtonProject.setEnabled(false);
        this.removeButtonProject = this.createButton(entryProject, Messages.ImplementationsPreferencesPage_Remove);
        this.removeButtonProject.setEnabled(false);
        d = (GridData)this.removeButtonProject.getLayoutData();
        d.verticalIndent = 5;
        projectTab.setControl((Control)entryProject);
        this.listImplementations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = AbstractImplementationsPreferencesPage.this.listImplementations.getSelectionIndex();
                String nameImplementation = AbstractImplementationsPreferencesPage.this.listImplementations.getItem(index);
                AbstractImplementationsPreferencesPage.this.templates = AbstractImplementationsPreferencesPage.this.helper.getTemplateList(nameImplementation);
                AbstractImplementationsPreferencesPage.this.listProject.setItems(AbstractImplementationsPreferencesPage.this.templates);
                ProjectVersion version = AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().getVersion(nameImplementation);
                if (version != null) {
                    AbstractImplementationsPreferencesPage.this.libraries = version.getLibraryNames();
                    listLibraries.setItems(AbstractImplementationsPreferencesPage.this.libraries);
                }
                AbstractImplementationsPreferencesPage.this.removeButtonImpl.setEnabled(true);
                AbstractImplementationsPreferencesPage.this.addButtonLibraries.setEnabled(true);
                AbstractImplementationsPreferencesPage.this.removeButtonLibraries.setEnabled(false);
                AbstractImplementationsPreferencesPage.this.addButtonProject.setEnabled(true);
                AbstractImplementationsPreferencesPage.this.editButtonProject.setEnabled(false);
                AbstractImplementationsPreferencesPage.this.upButtonProject.setEnabled(false);
                AbstractImplementationsPreferencesPage.this.downButtonProject.setEnabled(false);
                AbstractImplementationsPreferencesPage.this.removeButtonProject.setEnabled(false);
            }
        });
        listLibraries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractImplementationsPreferencesPage.this.removeButtonLibraries.setEnabled(true);
            }
        });
        this.listProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractImplementationsPreferencesPage.this.editButtonProject.setEnabled(true);
                AbstractImplementationsPreferencesPage.this.removeButtonProject.setEnabled(true);
                AbstractImplementationsPreferencesPage.this.updateUpDownProjectEnablement();
            }
        });
        this.addButtonImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newVersionNameImplementation = AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().addVersion();
                AbstractImplementationsPreferencesPage.this.implementations = AbstractImplementationsPreferencesPage.this.helper.getVersionList();
                AbstractImplementationsPreferencesPage.this.listImplementations.setItems(AbstractImplementationsPreferencesPage.this.implementations);
                if (newVersionNameImplementation != null) {
                    AbstractImplementationsPreferencesPage.this.listImplementations.setSelection(new String[]{newVersionNameImplementation});
                    AbstractImplementationsPreferencesPage.this.templates = AbstractImplementationsPreferencesPage.this.helper.getTemplateList(newVersionNameImplementation);
                    AbstractImplementationsPreferencesPage.this.listProject.setItems(AbstractImplementationsPreferencesPage.this.templates);
                    ProjectVersion version = AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().getVersion(newVersionNameImplementation);
                    if (version != null) {
                        AbstractImplementationsPreferencesPage.this.libraries = version.getLibraryNames();
                        listLibraries.setItems(AbstractImplementationsPreferencesPage.this.libraries);
                    }
                } else {
                    AbstractImplementationsPreferencesPage.this.removeButtonImpl.setEnabled(false);
                }
            }
        });
        this.removeButtonImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String nameImplementation;
                int index = AbstractImplementationsPreferencesPage.this.listImplementations.getSelectionIndex();
                if (index > -1 && (nameImplementation = AbstractImplementationsPreferencesPage.this.listImplementations.getItem(index)) != null) {
                    AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().removeVersion(nameImplementation);
                    AbstractImplementationsPreferencesPage.this.implementations = AbstractImplementationsPreferencesPage.this.helper.getVersionList();
                    AbstractImplementationsPreferencesPage.this.listImplementations.setItems(AbstractImplementationsPreferencesPage.this.implementations);
                    AbstractImplementationsPreferencesPage.this.removeButtonImpl.setEnabled(false);
                    AbstractImplementationsPreferencesPage.this.addButtonLibraries.setEnabled(false);
                    AbstractImplementationsPreferencesPage.this.addButtonProject.setEnabled(false);
                    listLibraries.setItems(new String[0]);
                    AbstractImplementationsPreferencesPage.this.listProject.setItems(new String[0]);
                }
            }
        });
        this.addButtonLibraries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = AbstractImplementationsPreferencesPage.this.listImplementations.getSelectionIndex();
                if (index > -1) {
                    String nameImplementation = AbstractImplementationsPreferencesPage.this.listImplementations.getItem(index);
                    ProjectVersion version = AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().getVersion(nameImplementation);
                    if (version != null) {
                        String nameLib = version.addLibrary();
                        AbstractImplementationsPreferencesPage.this.libraries = version.getLibraryNames();
                        listLibraries.setItems(AbstractImplementationsPreferencesPage.this.libraries);
                        if (nameLib != null) {
                            listLibraries.setSelection(new String[]{nameLib});
                        } else {
                            AbstractImplementationsPreferencesPage.this.removeButtonLibraries.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.removeButtonLibraries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = AbstractImplementationsPreferencesPage.this.listImplementations.getSelectionIndex();
                if (index > -1) {
                    String nameImplementation = AbstractImplementationsPreferencesPage.this.listImplementations.getItem(index);
                    int indexLib = listLibraries.getSelectionIndex();
                    if (indexLib > -1) {
                        String nameLib = listLibraries.getItem(indexLib);
                        ProjectVersion version = AbstractImplementationsPreferencesPage.this.helper.getProjectVersions().getVersion(nameImplementation);
                        if (version != null) {
                            version.removeLibrary(nameLib);
                            AbstractImplementationsPreferencesPage.this.libraries = version.getLibraryNames();
                            listLibraries.setItems(AbstractImplementationsPreferencesPage.this.libraries);
                            AbstractImplementationsPreferencesPage.this.removeButtonLibraries.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.addButtonProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractImplementationsPreferencesPage.this.addProject();
            }
        });
        this.upButtonProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int from = AbstractImplementationsPreferencesPage.this.listProject.getSelectionIndex();
                AbstractImplementationsPreferencesPage.this.moveProject(from, from - 1);
            }
        });
        this.downButtonProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int from = AbstractImplementationsPreferencesPage.this.listProject.getSelectionIndex();
                AbstractImplementationsPreferencesPage.this.moveProject(from, from + 1);
            }
        });
        this.removeButtonProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractImplementationsPreferencesPage.this.removeProject();
            }
        });
        this.editButtonProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractImplementationsPreferencesPage.this.editProject();
            }
        });
        return root;
    }

    private void updateUpDownProjectEnablement() {
        int s = this.listProject.getSelectionIndex();
        this.upButtonProject.setEnabled(s > 0);
        boolean downEnabled = s >= 0 && s < this.listProject.getItemCount() - 1;
        this.downButtonProject.setEnabled(downEnabled);
    }

    private String getSelectedImplementation() {
        int index = this.listImplementations.getSelectionIndex();
        return index < 0 ? null : this.listImplementations.getItem(index);
    }

    private String getSelectedProject() {
        int indexProject = this.listProject.getSelectionIndex();
        return indexProject < 0 ? null : this.listProject.getItem(indexProject);
    }

    private void addProject() {
        String nameImplementation = this.getSelectedImplementation();
        if (nameImplementation == null) {
            return;
        }
        int s = this.listProject.getSelectionIndex();
        String addNameProject = this.helper.addProjectTemplate(nameImplementation);
        this.templates = this.helper.getTemplateList(nameImplementation);
        this.listProject.setItems(this.templates);
        if (addNameProject != null) {
            this.listProject.setSelection(new String[]{addNameProject});
            int t = this.listProject.getSelectionIndex();
            if (t != s) {
                this.moveProject(t, s);
            }
        } else {
            this.editButtonProject.setEnabled(false);
            this.removeButtonProject.setEnabled(false);
        }
    }

    private void removeProject() {
        String nameImplementation = this.getSelectedImplementation();
        String nameProject = this.getSelectedProject();
        int s = this.listProject.getSelectionIndex();
        if (nameImplementation == null || nameProject == null) {
            return;
        }
        this.helper.removeProjectTemplate(nameImplementation, nameProject);
        this.templates = this.helper.getTemplateList(nameImplementation);
        this.listProject.setItems(this.templates);
        if (s >= this.listProject.getItemCount()) {
            s = this.listProject.getItemCount() - 1;
        }
        if (s >= 0) {
            this.listProject.setSelection(s);
            this.removeButtonProject.setEnabled(true);
            this.editButtonProject.setEnabled(true);
        } else {
            this.removeButtonProject.setEnabled(false);
            this.editButtonProject.setEnabled(false);
        }
        this.updateUpDownProjectEnablement();
    }

    private void moveProject(int from, int to) {
        if (from == to) {
            return;
        }
        if (from < 0 || to < 0) {
            return;
        }
        if (from >= this.listProject.getItemCount() || to >= this.listProject.getItemCount()) {
            return;
        }
        String nameImplementation = this.getSelectedImplementation();
        if (nameImplementation == null) {
            return;
        }
        ProjectVersion version = this.helper.getProjectVersions().getVersion(nameImplementation);
        String[] order = (String[])this.listProject.getItems().clone();
        String v = order[from];
        int di = from < to ? 1 : -1;
        int k = from;
        while (k != to) {
            order[k] = order[k + di];
            k += di;
        }
        order[to] = v;
        version.setOrder(order);
        this.listProject.setItems(order);
        this.listProject.setSelection(to);
        this.updateUpDownProjectEnablement();
    }

    private void editProject() {
        String nameImplementation = this.getSelectedImplementation();
        String nameProject = this.getSelectedProject();
        if (nameImplementation == null || nameProject == null) {
            return;
        }
        String newName = this.helper.editProjectTemplate(nameImplementation, nameProject);
        if (newName == null || newName.equals(nameProject)) {
            return;
        }
        this.templates = this.helper.getTemplateList(nameImplementation);
        this.listProject.setItems(this.templates);
        this.listProject.setSelection(new String[]{newName});
    }

    public void init(IWorkbench workbench) {
        this.helper = this.createHelper();
        this.errorMessage = this.helper.getProjectVersions().getErrorMessage();
        if (this.errorMessage == null) {
            this.implementations = this.helper.getVersionList();
        }
    }

    private Button createButton(Composite parent, String labelText) {
        Button button = new Button(parent, 8);
        GridData gridData = new GridData(128);
        gridData.verticalAlignment = 1;
        gridData.heightHint = this.heightHint;
        gridData.widthHint = Math.max(this.widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        if (labelText != null) {
            button.setText(labelText);
        }
        return button;
    }
}

