/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.kb.taglib.ITagLibRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibVersionRecognizer;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteModelImpl;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PagePaletteContents
extends PaletteContents {
    IEditorPart editorPart;
    Map<String, CategoryVersion> categoryVersions = new HashMap<String, CategoryVersion>();
    static Map<String, ITagLibRecognizer> taglibRecognizers = null;

    public PagePaletteContents(IEditorPart editorPart) {
        super(editorPart);
        this.editorPart = editorPart;
        PagePaletteContents.getTaglibRecognizers();
        this.computeVersions();
        this.computeRecognized();
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public IFile getFile() {
        IEditorInput input;
        if (this.editorPart != null && (input = this.editorPart.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public boolean update() {
        boolean r = super.update();
        if (this.computeVersions()) {
            this.computeRecognized();
            r = true;
        }
        return r;
    }

    public void dispose() {
        PaletteModel.disposeInstance(this);
        this.editorPart = null;
    }

    boolean computeVersions() {
        boolean result = false;
        IFile file = this.getFile();
        String[] types = this.getNatureTypes();
        if (types.length > 0 && PaletteModel.TYPE_HTML5.equals(types[0]) && file != null) {
            CategoryVersion[] categoryVersionArray = this.getVersionObjects();
            int n = categoryVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CategoryVersion v = categoryVersionArray[n2];
                if (v.computeVersion(file)) {
                    result = true;
                }
                ++n2;
            }
        }
        return result;
    }

    boolean computeRecognized() {
        boolean result = false;
        IFile file = this.getFile();
        String[] types = this.getNatureTypes();
        if (types.length > 0 && PaletteModel.TYPE_HTML5.equals(types[0]) && file != null) {
            CategoryVersion[] categoryVersionArray = this.getVersionObjects();
            int n = categoryVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CategoryVersion v = categoryVersionArray[n2];
                if (v.computeRecognized(file)) {
                    result = true;
                }
                ++n2;
            }
        }
        return result;
    }

    public IHTMLLibraryVersion getVersion(String category) {
        CategoryVersion v = this.getVersionObject(category);
        return v == null ? null : v.getVersion();
    }

    public boolean isRecognized(String category) {
        CategoryVersion v = this.getVersionObject(category);
        return v != null && v.recognized;
    }

    private synchronized CategoryVersion[] getVersionObjects() {
        return this.categoryVersions.values().toArray(new CategoryVersion[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CategoryVersion getVersionObject(String category) {
        ITagLibRecognizer r;
        CategoryVersion v = null;
        PagePaletteContents pagePaletteContents = this;
        synchronized (pagePaletteContents) {
            v = this.categoryVersions.get(category);
        }
        if (v == null && (r = taglibRecognizers.get(category)) instanceof ITagLibVersionRecognizer) {
            v = new CategoryVersion((ITagLibVersionRecognizer)r);
            PagePaletteContents pagePaletteContents2 = this;
            synchronized (pagePaletteContents2) {
                this.categoryVersions.put(category, v);
            }
            IFile file = this.getFile();
            if (file != null) {
                v.computeVersion(file);
                v.computeRecognized(file);
            }
        }
        return v;
    }

    public void setPreferredVersion(String category, IHTMLLibraryVersion version) {
        CategoryVersion v = this.categoryVersions.get(category);
        if (v != null && v.preferredVersion != version) {
            v.preferredVersion = version;
        }
    }

    static Map<String, ITagLibRecognizer> getTaglibRecognizers() {
        if (taglibRecognizers == null) {
            ArrayList<IPaletteGroup> paletteGroups = PaletteModelImpl.loadPaletteGroups();
            HashMap<String, ITagLibRecognizer> tr = new HashMap<String, ITagLibRecognizer>();
            for (IPaletteGroup group : paletteGroups) {
                ITagLibRecognizer recognizer = group.getRecognizer();
                if (recognizer == null) continue;
                tr.put(group.getName(), recognizer);
            }
            taglibRecognizers = tr;
        }
        return taglibRecognizers;
    }

    class CategoryVersion {
        ITagLibVersionRecognizer recognizer;
        IHTMLLibraryVersion detectedVersion = null;
        IHTMLLibraryVersion preferredVersion = null;
        boolean recognized = false;

        public CategoryVersion(ITagLibVersionRecognizer recognizer) {
            this.recognizer = recognizer;
        }

        public IHTMLLibraryVersion getVersion() {
            return this.preferredVersion != null ? this.preferredVersion : this.detectedVersion;
        }

        public boolean computeVersion(IFile file) {
            boolean isNew;
            IHTMLLibraryVersion newVersion = this.recognizer.getVersion(PageContextFactory.createPageContext((IFile)file));
            boolean bl = isNew = !this.isSame(newVersion);
            if (isNew) {
                this.preferredVersion = null;
                this.detectedVersion = newVersion;
            }
            return isNew;
        }

        public boolean computeRecognized(IFile file) {
            if (this.recognized != this.recognizer.isUsed(file)) {
                this.recognized = !this.recognized;
                return true;
            }
            return false;
        }

        private boolean isSame(IHTMLLibraryVersion newVersion) {
            return this.detectedVersion == null ? newVersion == null : this.detectedVersion.equals(newVersion);
        }
    }
}

