/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.impl.DiscardFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;
import org.jboss.tools.common.text.ext.IMultiPageEditor;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditorFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPEditorMessages;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditorPart;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditorSite;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageSelectionProvider;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PagePaletteContents;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PalettePageImpl;

public class JSPMultiPageEditor
extends JSPMultiPageEditorPart
implements XModelTreeListener,
ITextEditor,
IGotoMarker,
VpeTaglibManagerProvider,
IReusableEditor,
ITextEditorExtension,
ITextEditorExtension2,
ITextEditorExtension3,
INavigationLocationProvider,
IMultiPageEditor {
    private static final int MINIMUM_JRE_VERSION_FOR_VPE = 6;
    public static final String EDITOR_ID = "org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor";
    private static final String VPE_VISUAL_EDITOR_IMPL_ID = "org.jboss.tools.vpe.preview.editor.VpeEditorPartFactory";
    private static final String VISUAL_EDITOR_IMPL_EXTENSION_POINT_NAME = "visulaEditorImplementations";
    private IVisualEditor visualEditor;
    private boolean xulRunnerBrowserIsNotSupported = false;
    private boolean vpeIsCreating = true;
    private int visualSourceIndex;
    private int sourceIndex;
    private int previewIndex = -1;
    private JSPTextEditor sourceEditor;
    private BundleMap bundleMap;
    protected XModelTreeListenerSWTASync syncListener = new XModelTreeListenerSWTASync((XModelTreeListener)this);
    private ConfigurableContentOutlinePage outlinePage = null;
    private XModelObject object;
    private QualifiedName persistentTabQualifiedName = new QualifiedName("", "Selected_tab");
    int selectedPageIndex = 0;
    static IVisualEditorFactory visualEditorFactory;
    private ISelectionChangedListener externalizeSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            commandService.refreshElements("org.jboss.tools.jst.web.ui.internal.editor.commands.i18", null);
        }
    };
    private ISelectionProvider selectionProvider = null;
    private JSPMultiPageEditorSite site;
    PalettePageImpl palettePage;
    PagePaletteContents paletteContents;
    public static final QualifiedName PALETTE;
    public static final String PALETTE_VALUE = "true";
    public static final String VIEW_ID = "org.eclipse.gef.ui.palette_view";

    static {
        try {
            IExtension visualEditorExtension = Platform.getExtensionRegistry().getExtension("org.jboss.tools.jst.web.ui", VISUAL_EDITOR_IMPL_EXTENSION_POINT_NAME, VPE_VISUAL_EDITOR_IMPL_ID);
            if (visualEditorExtension != null) {
                IConfigurationElement[] configurationElements = visualEditorExtension.getConfigurationElements();
                if (configurationElements != null && configurationElements.length == 1) {
                    visualEditorFactory = (IVisualEditorFactory)configurationElements[0].createExecutableExtension("class");
                } else {
                    WebUiPlugin.getPluginLog().logError("Visual Editor Extension Point not configured correctly");
                }
            } else if (JSPMultiPageEditor.isRequiredJreVersionForVpe()) {
                WebUiPlugin.getPluginLog().logError("Visual Editor Implementation not available.");
            } else {
                WebUiPlugin.getPluginLog().logError("Visual Editor Implementation not available. It requires JRE 1.6 or later.");
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError("Visual Editor Implementation not available." + (Object)((Object)e));
        }
        PALETTE = new QualifiedName("org.jboss.tools.jst.web.ui", "PaletteWasOpened");
    }

    private void loadSelectedTab() {
        String defaultVpeTab = WebUiPlugin.getDefault().getPreferenceStore().getString("Default VPE Tab");
        this.selectedPageIndex = "0".equalsIgnoreCase(defaultVpeTab) ? 0 : ("1".equalsIgnoreCase(defaultVpeTab) ? 1 : ("2".equalsIgnoreCase(defaultVpeTab) ? 2 : 0));
        if (this.visualEditor == null) {
            this.selectedPageIndex = 0;
        }
    }

    private static boolean isRequiredJreVersionForVpe() {
        int majorVersion;
        Matcher matcher;
        String javaVersion = System.getProperty("java.version");
        Pattern pattern = Pattern.compile("1\\.(\\d{1,6})\\..*");
        return javaVersion == null || !(matcher = pattern.matcher(javaVersion)).matches() || (majorVersion = Integer.valueOf(matcher.group(1)).intValue()) >= 6;
    }

    public void pageChange(int newPageIndex) {
        this.selectedPageIndex = newPageIndex;
        if (this.visualEditor != null) {
            if (this.selectedPageIndex == this.visualSourceIndex) {
                if (this.visualEditor.getVisualEditor() == null) {
                    this.visualEditor.createVisualEditor();
                    if (this.isXulRunnerBrowserNotSupported() && this.vpeIsCreating) {
                        this.visualEditor.setVisualMode(1);
                        this.selectedPageIndex = 1;
                        this.setActivePage(this.selectedPageIndex);
                    } else {
                        this.visualEditor.setVisualMode(0);
                    }
                } else {
                    this.visualEditor.setVisualMode(0);
                }
            } else if (this.selectedPageIndex == this.sourceIndex) {
                this.visualEditor.setVisualMode(1);
            } else if (this.selectedPageIndex == this.getPreviewIndex()) {
                if (this.visualEditor.getPreviewWebBrowser() == null) {
                    this.visualEditor.createPreviewBrowser();
                    if (this.isXulRunnerBrowserNotSupported() && this.vpeIsCreating) {
                        this.visualEditor.setVisualMode(1);
                        this.selectedPageIndex = 1;
                        this.setActivePage(this.selectedPageIndex);
                    } else {
                        this.visualEditor.setVisualMode(2);
                    }
                } else {
                    this.visualEditor.setVisualMode(2);
                }
            }
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements("org.jboss.tools.jst.web.ui.internal.editor.commands.showSelectionBar", null);
        this.getSelectionBar().refreshVisibility();
        super.pageChange(this.selectedPageIndex);
        WebUiPlugin.getDefault().getPreferenceStore().setValue("Default VPE Tab", this.selectedPageIndex);
    }

    public int getSelectedPageIndex() {
        return this.selectedPageIndex;
    }

    public void setInput(IEditorInput input) {
        super.setInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            this.object = ((IModelObjectEditorInput)this.getEditorInput()).getXModelObject();
        }
        if (this.sourceEditor != null && this.sourceEditor.getEditorInput() != this.getEditorInput() && this.sourceEditor.getEditorInput() != null) {
            if (this.sourceEditor instanceof AbstractTextEditor) {
                this.sourceEditor.setInput(this.getEditorInput());
            }
            if (this.visualEditor != null) {
                this.visualEditor.setInput(this.getEditorInput());
            }
            this.updateTitle();
        }
        this.updateFile();
    }

    public void setInput0(IEditorInput input) {
        super.setInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        this.updateFile();
        this.firePropertyChange(258);
    }

    private void updateFile() {
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logWarning((Throwable)e);
        }
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    public String getContentDescription() {
        return "";
    }

    @Override
    protected IEditorSite createSite(IEditorPart editor) {
        this.site = new JSPMultiPageEditorSite(this, editor){
            private ISelectionChangedListener postSelectionChangedListener;
            {
                this.postSelectionChangedListener = null;
            }

            private ISelectionChangedListener getPostSelectionChangedListener() {
                if (this.postSelectionChangedListener == null) {
                    this.postSelectionChangedListener = new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            this.handlePostSelectionChanged(event);
                        }
                    };
                }
                return this.postSelectionChangedListener;
            }

            @Override
            protected void handlePostSelectionChanged(SelectionChangedEvent event) {
                ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
                ISelection s = event.getSelection();
                if (s == null || s.isEmpty()) {
                    return;
                }
                if (s instanceof ITextSelection && parentProvider instanceof JSPMultiPageSelectionProvider) {
                    ((JSPMultiPageSelectionProvider)parentProvider).firePostSelectionChanged(event);
                }
            }

            @Override
            public String getId() {
                return JSPMultiPageEditor.this.getSite().getId();
            }

            public ISelectionProvider getSelectionProvider() {
                return JSPMultiPageEditor.this.selectionProvider;
            }

            public void setSelectionProvider(ISelectionProvider provider) {
                ISelectionProvider oldSelectionProvider = this.getSelectionProvider();
                if (oldSelectionProvider != null && oldSelectionProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
                }
                JSPMultiPageEditor.this.selectionProvider = provider;
                if (oldSelectionProvider != null) {
                    oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
                }
                if (JSPMultiPageEditor.this.selectionProvider != null) {
                    JSPMultiPageEditor.this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
                    JSPMultiPageEditor.this.selectionProvider.addSelectionChangedListener(JSPMultiPageEditor.this.externalizeSelectionChangeListener);
                }
                if (provider != null && provider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)provider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
                }
            }

            @Override
            public void dispose() {
                ISelectionProvider provider = this.getSelectionProvider();
                if (provider != null) {
                    provider.removeSelectionChangedListener(this.getSelectionChangedListener());
                    provider.removeSelectionChangedListener(JSPMultiPageEditor.this.externalizeSelectionChangeListener);
                }
                if (provider instanceof IPostSelectionProvider && this.postSelectionChangedListener != null) {
                    ((IPostSelectionProvider)provider).removePostSelectionChangedListener(this.postSelectionChangedListener);
                }
                this.postSelectionChangedListener = null;
                super.dispose();
            }
        };
        return this.site;
    }

    protected void createPages() {
        block12: {
            try {
                try {
                    this.createPagesForVPE();
                    this.loadSelectedTab();
                    switch (this.selectedPageIndex) {
                        case 0: {
                            this.setActivePage(this.selectedPageIndex);
                            break;
                        }
                        case 1: {
                            this.setActivePage(this.selectedPageIndex);
                            break;
                        }
                        case 2: {
                            this.setActivePage(this.selectedPageIndex);
                            break;
                        }
                        default: {
                            this.setActivePage(0);
                        }
                    }
                    IFile f = this.getFile();
                    if (f != null && f.exists()) {
                        new ResourceChangeListener((IEditorPart)this, this.getContainer());
                    }
                    if (this.getModelObject() != null) {
                        this.getModelObject().getModel().addModelTreeListener((XModelTreeListener)this.syncListener);
                    }
                }
                catch (PartInitException e) {
                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                    this.vpeIsCreating = false;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.vpeIsCreating = false;
                throw throwable;
            }
            this.vpeIsCreating = false;
        }
        this.checkPalette();
    }

    private void createPagesForVPE() throws PartInitException {
        this.sourceEditor = new JSPTextEditor(this){

            @Override
            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                Menu m = JSPMultiPageEditor.this.sourceEditor.getTextViewer().getTextWidget().getMenu();
                Object data = m.getData("org.eclipse.jface.action.MenuManager.managerKey");
                if (data instanceof IMenuManager) {
                    ((IMenuManager)data).addMenuListener((IMenuListener)new ZContextMenuListener());
                }
            }
        };
        this.sourceEditor.setEditorPart((IEditorPart)this);
        this.bundleMap = new BundleMap();
        String sourceTabLabel = JSPEditorMessages.JSPMultiPageEditor_TabLabel_Source;
        if (visualEditorFactory != null) {
            this.visualEditor = visualEditorFactory.createVisualEditor((EditorPart)this, this.sourceEditor, 0, this.bundleMap);
            if (this.visualEditor != null) {
                this.visualSourceIndex = this.addPage((IEditorPart)this.visualEditor, this.getEditorInput(), this.sourceEditor);
                this.setPageText(this.visualSourceIndex, JSPEditorMessages.JSPMultiPageEditor_TabLabel_VisualSource);
                this.setPartName(this.visualEditor.getTitle());
                this.sourceIndex = this.addPage((IEditorPart)this.visualEditor, this.getEditorInput(), this.sourceEditor);
                this.setPageText(this.sourceIndex, sourceTabLabel);
                this.setPartName(this.visualEditor.getTitle());
                this.setPreviewIndex(this.addPage((IEditorPart)this.visualEditor, this.getEditorInput(), this.sourceEditor));
                this.setPageText(this.getPreviewIndex(), JSPEditorMessages.JSPMultiPageEditor_TabLabel_Preview);
                this.setPartName(this.visualEditor.getTitle());
            } else {
                this.createOnlySourceTab(sourceTabLabel);
            }
        } else {
            this.createOnlySourceTab(sourceTabLabel);
        }
    }

    private void createOnlySourceTab(String sourceTabLabel) throws PartInitException {
        this.sourceIndex = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput(), this.sourceEditor);
        this.setPageText(this.sourceIndex, sourceTabLabel);
        this.setPartName(this.sourceEditor.getTitle());
        this.bundleMap.init(this.sourceEditor.getEditorInput());
    }

    public void doSave(IProgressMonitor monitor) {
        this.sourceEditor.doSave(monitor);
    }

    public void doSaveAs() {
        XModelObject old = this.getModelObject();
        PCL pcl = new PCL();
        this.sourceEditor.addPropertyListener(pcl);
        this.sourceEditor.doSaveAs();
        this.sourceEditor.removePropertyListener(pcl);
        try {
            if (old.isModified()) {
                new DiscardFileHandler().executeHandler(old, new Properties());
            }
        }
        catch (XModelException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void gotoMarker(IMarker marker) {
        int pageToActivate = 1 < this.getPageCount() ? 1 : 0;
        this.setActivePage(pageToActivate);
        this.pageChange(pageToActivate);
        IGotoMarker adapter = (IGotoMarker)this.sourceEditor.getAdapter(IGotoMarker.class);
        if (adapter != null) {
            adapter.gotoMarker(marker);
        }
    }

    public boolean isSaveAsAllowed() {
        return this.sourceEditor.isSaveAsAllowed();
    }

    public JSPTextEditor getJspEditor() {
        return this.sourceEditor;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IVisualEditor getVisualEditor() {
        return this.visualEditor;
    }

    public IEditorPart getActivePageEditor() {
        return this.getActiveEditor();
    }

    protected XModelObject getModelObject() {
        return this.object;
    }

    @Override
    public void dispose() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(null);
        }
        if (this.visualEditor != null) {
            this.visualEditor.dispose();
        }
        if (this.site != null) {
            this.site.dispose();
            this.site = null;
        }
        this.outlinePage = null;
        XModelObject o = this.getModelObject();
        if (o != null) {
            o.getModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
        }
        if (this.syncListener != null) {
            this.syncListener.dispose();
        }
        this.syncListener = null;
        if (o != null && o.isModified() && o.isActive()) {
            try {
                ((FolderImpl)o.getParent()).discardChildFile(o);
            }
            catch (XModelException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (this.palettePage != null) {
            this.palettePage.dispose();
            this.palettePage = null;
        }
        IContextService cfr_ignored_0 = (IContextService)this.getSite().getService(IContextService.class);
        if (this.paletteContents != null) {
            this.paletteContents.dispose();
            this.paletteContents = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (PalettePage.class == adapter) {
            if (this.palettePage == null || this.palettePage.isDisposed()) {
                IDocument d = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                if (d == null) {
                    return null;
                }
                this.palettePage = new PalettePageImpl();
                if (this.paletteContents == null) {
                    this.paletteContents = new PagePaletteContents((IEditorPart)this);
                }
                this.palettePage.setPaletteContents(this.paletteContents);
                this.palettePage.attach(d);
            }
            return this.palettePage;
        }
        if (PagePaletteContents.class == adapter) {
            if (this.paletteContents == null) {
                this.paletteContents = new PagePaletteContents((IEditorPart)this);
            }
            return this.paletteContents;
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.visualEditor != null) {
                if (this.outlinePage == null) {
                    this.outlinePage = (ConfigurableContentOutlinePage)this.visualEditor.getAdapter(adapter);
                }
                return this.outlinePage;
            }
        } else if (IPropertySheetPage.class.equals((Object)adapter)) {
            if (this.sourceEditor != null) {
                return this.sourceEditor.getAdapter(adapter);
            }
        } else if (adapter == EditorDescriptor.class) {
            return new EditorDescriptor(new String[]{"jsp", "html", "htm"});
        }
        if (this.sourceEditor != null) {
            return this.sourceEditor.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (event.getModelObject() == this.getModelObject() && this.sourceEditor != null) {
            this.sourceEditor.updateModification();
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public void close(boolean save) {
        this.sourceEditor.close(save);
    }

    public void doRevertToSaved() {
        this.sourceEditor.doRevertToSaved();
    }

    public IAction getAction(String actionId) {
        return this.sourceEditor.getAction(actionId);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.sourceEditor.getDocumentProvider();
    }

    public IRegion getHighlightRange() {
        return this.sourceEditor.getHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.sourceEditor.getSelectionProvider();
    }

    public boolean isEditable() {
        return this.sourceEditor.isEditable();
    }

    public void removeActionActivationCode(String actionId) {
        this.sourceEditor.removeActionActivationCode(actionId);
    }

    public void resetHighlightRange() {
        this.sourceEditor.resetHighlightRange();
    }

    public void selectAndReveal(int offset, int length) {
        this.sourceEditor.selectAndReveal(offset, length);
    }

    public void setAction(String actionID, IAction action) {
        this.sourceEditor.setAction(actionID, action);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this.sourceEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this.sourceEditor.setHighlightRange(offset, length, moveCursor);
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.sourceEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public boolean showsHighlightRangeOnly() {
        return this.sourceEditor.showsHighlightRangeOnly();
    }

    public VpeTaglibManager getTaglibManager() {
        if (this.sourceEditor != null && this.sourceEditor.getPageContext() instanceof VpeTaglibManager) {
            return (VpeTaglibManager)this.sourceEditor.getPageContext();
        }
        return null;
    }

    void updateTitle() {
        this.setPartName(this.getEditorInput().getName());
    }

    public void runDropCommand(String flavor, String data) {
        if (this.sourceEditor != null) {
            this.sourceEditor.runDropCommand(flavor, data);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setStatusField(field, category);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.addRulerContextMenuListener(listener);
        }
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.removeRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputModifiable() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputModifiable();
        }
        return false;
    }

    public boolean validateEditorInputState() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.validateEditorInputState();
        }
        return false;
    }

    public ITextEditorExtension3.InsertMode getInsertMode() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.getInsertMode();
        }
        return null;
    }

    public void setInsertMode(ITextEditorExtension3.InsertMode mode) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setInsertMode(mode);
        }
    }

    public void showChangeInformation(boolean show) {
        if (this.sourceEditor != null) {
            this.sourceEditor.showChangeInformation(show);
        }
    }

    public boolean isChangeInformationShowing() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isChangeInformationShowing();
        }
        return false;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.createEmptyNavigationLocation();
        }
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.createNavigationLocation();
        }
        return null;
    }

    public void updatePartAccordingToPreferences() {
        String tabIndex = WebUiPlugin.getDefault().getPreferenceStore().getString("Default VPE Tab");
        try {
            int ind = Integer.parseInt(tabIndex);
            this.setActivePage(ind);
            this.pageChange(ind);
        }
        catch (NumberFormatException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public int getPreviewIndex() {
        return this.previewIndex;
    }

    public void setPreviewIndex(int previewIndex) {
        this.previewIndex = previewIndex;
    }

    public void setVisualSourceIndex(int visualSourceIndex) {
        this.visualSourceIndex = visualSourceIndex;
    }

    public int getVisualSourceIndex() {
        return this.visualSourceIndex;
    }

    public IProject getProject() {
        IProject pr = null;
        IFile file = this.getFile();
        if (file != null) {
            pr = file.getProject();
        }
        return pr;
    }

    public boolean isXulRunnerBrowserNotSupported() {
        return this.xulRunnerBrowserIsNotSupported;
    }

    public void setXulRunnerBrowserIsNotSupported(boolean xulRunnerBrowserIsNotSupported) {
        this.xulRunnerBrowserIsNotSupported = xulRunnerBrowserIsNotSupported;
    }

    private void checkPalette() {
        if (!JSPMultiPageEditor.wasPaletteOpened()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JSPMultiPageEditor.this.openPalette();
                }
            });
            JSPMultiPageEditor.setPaletteOpened();
        }
    }

    public static boolean wasPaletteOpened() {
        try {
            return PALETTE_VALUE.equals(ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(PALETTE));
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
            return true;
        }
    }

    public static void resetPaletteOpened() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(PALETTE, null);
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }

    private void openPalette() {
        IWorkbenchPage page;
        IWorkbenchWindow window = WebUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView(VIEW_ID);
            if (part == null) {
                try {
                    part = page.showView(VIEW_ID, null, 2);
                }
                catch (PartInitException e) {
                    WebUiPlugin.getDefault().logError(e);
                }
            } else {
                page.bringToTop((IWorkbenchPart)part);
            }
        }
    }

    private static void setPaletteOpened() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(PALETTE, PALETTE_VALUE);
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }

    public void switchToSourceTab() {
        this.setActiveEditor((IEditorPart)this.sourceEditor);
    }

    class PCL
    implements IPropertyListener {
        PCL() {
        }

        public void propertyChanged(Object source, int i) {
            JSPMultiPageEditor.this.firePropertyChange(i);
            if (i == 258 && JSPMultiPageEditor.this.getEditorInput() != JSPMultiPageEditor.this.sourceEditor.getEditorInput()) {
                JSPMultiPageEditor.this.setInput(JSPMultiPageEditor.this.sourceEditor.getEditorInput());
                JSPMultiPageEditor.this.setPartName(JSPMultiPageEditor.this.sourceEditor.getPartName());
                JSPMultiPageEditor.this.setTitleToolTip(JSPMultiPageEditor.this.sourceEditor.getTitleToolTip());
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        IEditorPart editorPart;
        Composite container;

        ResourceChangeListener(IEditorPart editorPart, Composite container) {
            this.editorPart = editorPart;
            this.container = container;
            IWorkspace workspace = ModelUIPlugin.getWorkspace();
            if (workspace == null) {
                return;
            }
            workspace.addResourceChangeListener((IResourceChangeListener)this);
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    IWorkspace workspace = ModelUIPlugin.getWorkspace();
                    if (workspace == null) {
                        return;
                    }
                    workspace.removeResourceChangeListener((IResourceChangeListener)ResourceChangeListener.this);
                }
            });
        }

        public void resourceChanged(IResourceChangeEvent event) {
            XModelObject p;
            IEditorInput ei = this.editorPart.getEditorInput();
            if (!(ei instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput fi = (IFileEditorInput)ei;
            IFile f = fi.getFile();
            if (f == null) {
                return;
            }
            IPath path = this.getPathChange(event, f);
            if (path == null) {
                if (f != null && !f.exists()) {
                    this.closeEditor();
                }
                return;
            }
            f = ModelPlugin.getWorkspace().getRoot().getFile(path);
            XModelObject xModelObject = p = f == null ? null : EclipseResourceUtil.createObjectForResource((IResource)f.getParent());
            if (p instanceof FolderImpl) {
                ((FolderImpl)p).update();
            }
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)f);
            if (f != null && f.exists() && o != null && this.editorPart instanceof JSPMultiPageEditor) {
                final JSPMultiPageEditor e = (JSPMultiPageEditor)this.editorPart;
                if (ei instanceof XModelObjectEditorInput) {
                    IModelObjectEditorInput e2 = XModelObjectEditorInput.createInstance((XModelObject)o);
                    Display.getDefault().asyncExec(new Runnable((IEditorInput)e2, ei){
                        private final /* synthetic */ IEditorInput val$e2;
                        private final /* synthetic */ IEditorInput val$ei;
                        {
                            this.val$e2 = iEditorInput;
                            this.val$ei = iEditorInput2;
                        }

                        @Override
                        public void run() {
                            e.setInput0(this.val$e2);
                            e.updateTitle();
                            if (e.getJspEditor() instanceof AbstractTextEditor) {
                                if (e.getJspEditor() != null && e.getJspEditor().getEditorInput() != e.getEditorInput()) {
                                    e.getJspEditor().setInput(this.val$e2);
                                }
                                ((XModelObjectEditorInput)this.val$ei).synchronize();
                            }
                        }
                    });
                }
            }
            if (f == null || f.exists()) {
                return;
            }
            this.closeEditor();
        }

        private void closeEditor() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceChangeListener.this.editorPart.getSite().getPage().closeEditor(ResourceChangeListener.this.editorPart, false);
                }
            });
        }

        private IPath getPathChange(IResourceChangeEvent event, IFile f) {
            return this.getPathChange(event.getDelta(), f.getFullPath());
        }

        private IPath getPathChange(IResourceDelta delta, IPath p) {
            if (delta == null || delta.getFullPath() == null) {
                return null;
            }
            if (!delta.getFullPath().isPrefixOf(p)) {
                return null;
            }
            if (delta != null && delta.getKind() == 4) {
                IResourceDelta[] ds = delta.getAffectedChildren();
                if (ds == null) {
                    return null;
                }
                if (ds.length > 1) {
                    IPath removed = null;
                    IPath added = null;
                    int i = 0;
                    while (i < ds.length) {
                        IPath d = ds[i].getFullPath();
                        if (ds[i].getKind() == 2 && (d.equals((Object)p) || d.isPrefixOf(p))) {
                            removed = d;
                        } else if (ds[i].getKind() == 1) {
                            added = d;
                        }
                        ++i;
                    }
                    if (removed != null && added != null) {
                        IPath d = removed;
                        if (d.equals((Object)p)) {
                            return added;
                        }
                        if (d.isPrefixOf(p)) {
                            return added.append(p.removeFirstSegments(d.segmentCount()));
                        }
                    }
                }
                int i = 0;
                while (i < ds.length) {
                    IPath ps = this.getPathChange(ds[i], p);
                    if (ps != null) {
                        return ps;
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private final class ZContextMenuListener
    implements IMenuListener {
        private ZContextMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            Item[] mi = this.getMenuItems(manager);
            int i = 0;
            while (i < mi.length) {
                mi[i].dispose();
                ++i;
            }
        }

        Item[] getMenuItems(IMenuManager manager) {
            Menu menu = ((MenuManager)manager).getMenu();
            return menu == null ? new Item[]{} : menu.getItems();
        }
    }
}

